#ifndef __EXPORT_H
#define __EXPORT_H


#include <qlist.h>
#include <qstring.h>
#include <qobject.h>

#include "column.h"
#include "table.h"



/**
 *   Export Filter BaseClass declaration
 *
 *   This class defines the interface of all export filters.
 *   The exportfilter must return its name, its optionsslot
 *   and must store the table to disk.
 *
 *   Very cool structure: only this file has to be included by the main
 *   program. All filters have to be compiled to an object file and this
 *   object file has then to be linked to the main executable.
 *   They dont need to be included at any positon!!!
 *   So leave their includefiles where they are. Dont copy them to
 *   the korigin include directory.
 *
 *
 *   Write new export filters by inheriting the class exportfilter
 *   and defining all virtual declared functions.
 *
 *
 *   Written for the KOrigin project by
 *
 *   (C) 1997/98 by Martin Hfner    
 *
 */
class exportFilter
{
  public:
    exportFilter () {};
    virtual ~exportFilter () {};

    /**
     * returns a popup built from all found export filters.
     * Already connected to the apropriate slots.
     */
    static QPopupMenu* getExportFilterPopup ();

    /**
     * returns a options popup built from all found export filters.
     * Already connected to the apropriate slots.
     */
    static QPopupMenu* getExportOptionsPopup ();

    /**
     *  Exporting Worksheet to File. Later a function exportToUrl will perhaps
     *  be included.
     */
    void exportToFile ();

    /**
     *  Returns a description string for building the GUI
     *
     */
    virtual QString getDescription () = 0;

    /**
     *  runs the complete options dialogs
     */
    virtual void getOptionsSlot () = 0;


  protected:
    virtual const char* getFileFilter () = 0;
    virtual void writeTable (const char* filename, Table* T) = 0;    

    virtual QString getLatestDirectory () = 0;
    virtual void setLatestDirectory (const char* dir) = 0;

    virtual QString getDefaultDirectory () = 0;
    virtual void setDefaultDirectory (const char* dir) = 0;
};



/**
 *  The export Module runner. Do not do anything with this class.
 *  It is a helper class for exportFilter.
 *
 */
class runExportFilters : public QObject
{
  Q_OBJECT

  public slots:
    /**
     *  runs the exporting of worksheets
     */
    void exportTable (int i);

    /**
     *  shows and runs the correct options dialog
     */
    void exportOptions (int i);
};



//
// define the export filters list here
//

typedef QList<exportFilter> ExportFilterList;
ExportFilterList& exportFilterList ();


#endif








