#include <kanalyzer.h>
#include <kanalyzer.moc>

#include <kmsgbox.h>

#include <xpm/filenew.xpm>
#include <xpm/fileprint.xpm>
#include <xpm/fileopen.xpm>
#include <xpm/filesave.xpm>
#include <xpm/editcopy.xpm>
#include <xpm/editcut.xpm>
#include <xpm/editpaste.xpm>
#include <xpm/help.xpm>

/* constants */
const char* chExit = "E&xit";
const char* chFile = "&File";
const char* chHelp = "&Help";

const char* chNew = "New";
const char* chOpen = "Open";
const char* chSave = "Save";
const char* chCut = "Cut";
const char* chCopy = "Copy";
const char* chPaste = "Paste";
const char* chPrint = "Print";
const char* chAbout = "About";
const char* chHelpPage = "kanalyzer/kanalyzer.html";
const char* chEmpty = "";
const char* chReady = "Ready";
const char* chWarning = "Warning";
const char* chNotImplemted = "Not implemented";
const char* chAbort = "Abort";

const int iLabelPos = 1;

const char* appIniFile = "kanalyzer.ini";
const char* appWindowRect = "AppWindowRect";
const QRect rapp(0,0,800,600);

KConfig* config;

KAnalyzer::KAnalyzer(QWidget *parent, const char *name)
	: KTopLevelWidget(name)
{
	config = new KConfig(appIniFile);
	setGeometry(config->readRectEntry(appWindowRect, &rapp));

	QString kde_toolbardir = kapp->kde_toolbardir();
	
	QPopupMenu *file_menu = new QPopupMenu();
	file_menu->insertItem(i18n(chExit), kapp, SLOT(quit()));

	QPopupMenu *help_menu = new QPopupMenu();
	help_menu->insertItem(i18n(chHelp), this, SLOT(invokeHelp()));

	menuBar = new KMenuBar(this);
	menuBar->insertItem(i18n(chFile), file_menu);
	menuBar->insertItem(i18n(chHelp), help_menu);

	setMenu(menuBar);

	/*				ToolBar				*/
	toolBar = new KToolBar(this);
	addToolBar(toolBar);
	
	toolBar->insertButton(QPixmap((const char**)filenew_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								true, chNew); 
	toolBar->insertButton(QPixmap((const char**)fileopen_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								true, chOpen); 
	toolBar->insertButton(QPixmap((const char**)filesave_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								true, chSave); 
	toolBar->insertSeparator();
	toolBar->insertButton(QPixmap((const char**)editcut_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								false, chCut); 
	toolBar->insertButton(QPixmap((const char**)editcopy_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								false, chCopy); 
	toolBar->insertButton(QPixmap((const char**)editpaste_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								false, chPaste); 
	toolBar->insertSeparator();
	toolBar->insertButton(QPixmap((const char**)fileprint_xpm),
								0, SIGNAL(clicked()), this, SLOT(notImplemented()), 
								true, chPrint); 
	toolBar->insertSeparator();
	toolBar->insertButton(QPixmap((const char**)help_xpm),
								0, SIGNAL(clicked()), this, SLOT(invokeHelp()), 
								true, chAbout); 

	statusBar = new KStatusBar(this);
	statusBar->insertItem(i18n(chReady), iLabelPos);

	setStatusBar(statusBar);

	view = new KAnalyzerWidget(this);
	setView(view);

}

KAnalyzer::~KAnalyzer()
{
	config->writeEntry(appWindowRect, geometry());
	config->sync();
	
	delete toolBar;
	delete statusBar;
	delete menuBar;
}

void KAnalyzer::invokeHelp()
{
	kapp->invokeHTMLHelp(chHelpPage, chEmpty);
}

void KAnalyzer::notImplemented()
{
	KMsgBox::message(this,  chWarning, chNotImplemted,
						KMsgBox::EXCLAMATION, chAbort);
}

