#ifndef __d56ioctl_h
#define __d56ioctl_h

/* d56ioctl.h    Include file for Goldammer DSP56-3 Driver   */

#define DSP56_DRIVERNAME    "dsp56-3"
        
/* Control Codes */
#define D56_BASE_CODE 0x400

#define IOCTL_D56_RESET				D56_BASE_CODE
#define IOCTL_D56_BOOTLOAD			D56_BASE_CODE + 0x01
#define IOCTL_D56_HP_READ			D56_BASE_CODE + 0x02
#define IOCTL_D56_HP_WRITE			D56_BASE_CODE + 0x03
#define IOCTL_D56_CVR_READ			D56_BASE_CODE + 0x04
#define IOCTL_D56_CVR_WRITE			D56_BASE_CODE + 0x05
#define IOCTL_D56_ICR_READ			D56_BASE_CODE + 0x06 
#define IOCTL_D56_ICR_WRITE			D56_BASE_CODE + 0x07
#define IOCTL_D56_IVR_READ			D56_BASE_CODE + 0x08
#define IOCTL_D56_IVR_WRITE			D56_BASE_CODE + 0x09
#define IOCTL_D56_ISR_READ			D56_BASE_CODE + 0x0A
#define IOCTL_D56_MEMORY_SELECT		D56_BASE_CODE + 0x0B
#define IOCTL_D56_SR_WRITE			D56_BASE_CODE + 0x0C         
#define IOCTL_D56_SR_READ			D56_BASE_CODE + 0x0D
#define IOCTL_D56_SR_ADRPTR			D56_BASE_CODE + 0x0E

#define IOCTL_D56_SR_BLOCK_WRITE	D56_BASE_CODE + 0x10
#define IOCTL_D56_SR_BLOCK_READ		D56_BASE_CODE + 0x11      
#define IOCTL_D56_SR_SETBUFFER		D56_BASE_CODE + 0x12 
#define IOCTL_D56_INTERRUPT_RESET	D56_BASE_CODE + 0x13
#define IOCTL_D56_GET_CTRLS			D56_BASE_CODE + 0x14
#define IOCTL_D56_REGISTER			D56_BASE_CODE + 0x15	
#define IOCTL_D56_RELEASE			D56_BASE_CODE + 0x16	
#define IOCTL_D56_GET_VERSION		D56_BASE_CODE + 0x17	
#define IOCTL_D56_GET_TYPE			D56_BASE_CODE + 0x18
#define IOCTL_D56_WAIT_FOR_SIGNAL	D56_BASE_CODE + 0x19
#define IOCTL_D56_TCR_READ			D56_BASE_CODE + 0x1A
#define IOCTL_D56_TCR_WRITE			D56_BASE_CODE + 0x1B

#define IOCTL_D56_TR1_READ			D56_BASE_CODE + 0x1C
#define IOCTL_D56_TR1_WRITE			D56_BASE_CODE + 0x1D
#define IOCTL_D56_TR2_READ			D56_BASE_CODE + 0x1E
#define IOCTL_D56_TR2_WRITE			D56_BASE_CODE + 0x1F
#define IOCTL_D56_TR3_READ			D56_BASE_CODE + 0x20
#define IOCTL_D56_TR3_WRITE			D56_BASE_CODE + 0x21
#define IOCTL_D56_FIFO_READ			D56_BASE_CODE + 0x22
#define IOCTL_D56_FIFO_STATE		D56_BASE_CODE + 0x23
#define IOCTL_D56_FIFO_FLUSH		D56_BASE_CODE + 0x24

typedef struct
{
	unsigned long Bootloader[512];
} DSP56BOOT, *PDSP56BOOT;

typedef struct
{
	unsigned short  Value;
	unsigned short  Flag;
	unsigned char   Register;
	unsigned long   HostPort;
	unsigned short* Buffer;
} DSP56STRUCT, *PDSP56STRUCT;

#endif
