#include <qwt_counter.h>
#include <qwt_math.h>

#include "qwt_counter.moc"

const int MAXBTNS=3;
const int MIN_LBL_WIDTH = 50;

QwtCounter::QwtCounter(QWidget *parent, char *name )
: QWidget(parent,name)
{
	int i;
	
	d_nButtons = 2;
	d_Inc[0] = 1;
	d_Inc[1] = 10;
	d_Inc[2] = 100;
	
	d_tmrIntv = 200;

	lblValue = new QLabel(this);
	lblValue->setNum(0.0);
	lblValue->setAlignment(AlignCenter);
	lblValue->setFrameStyle(QFrame::Panel|QFrame::Sunken);

	for(i=0;i<MAXBTNS;i++)
	{
		btnL[i] = new QPushButton(this);
		btnR[i] = new QPushButton(this);
	}

	btnL[0]->setText("<");
	btnL[1]->setText("<<");
	btnL[2]->setText("<<<");
	
	btnR[0]->setText(">");
	btnR[1]->setText(">>");
	btnR[2]->setText(">>>");
	
	connect(btnL[0], SIGNAL(pressed()), SLOT(btnL1Dn()));
	connect(btnL[1], SIGNAL(pressed()), SLOT(btnL2Dn()));
	connect(btnL[2], SIGNAL(pressed()), SLOT(btnL3Dn()));
	connect(btnR[0], SIGNAL(pressed()), SLOT(btnR1Dn()));
	connect(btnR[1], SIGNAL(pressed()), SLOT(btnR2Dn()));
	connect(btnR[2], SIGNAL(pressed()), SLOT(btnR3Dn()));
	connect(btnL[0], SIGNAL(released()), SLOT(btnUp()));
	connect(btnL[1], SIGNAL(released()), SLOT(btnUp()));
	connect(btnL[2], SIGNAL(released()), SLOT(btnUp()));
	connect(btnR[0], SIGNAL(released()), SLOT(btnUp()));
	connect(btnR[1], SIGNAL(released()), SLOT(btnUp()));
	connect(btnR[2], SIGNAL(released()), SLOT(btnUp()));
	
	setRange(0.0,1.0,0.001);
	setValue(0.0);
	
}

void QwtCounter::resizeEvent(QResizeEvent *e)
{
	int btnWidth,i;
	
	QSize r(e->size());
	btnWidth = r.height();
	
	btnWidth = qwtMin(r.height(), (r.width() - MIN_LBL_WIDTH) / ( 2 * d_nButtons));
	btnWidth = qwtMax(btnWidth,5);
	
	for (i=0;i<d_nButtons;i++)
	{
		btnL[i]->resize(btnWidth,r.height());
		btnL[i]->move((d_nButtons - i - 1) * btnWidth, 0);
		btnR[i]->resize(btnWidth, r.height());
		btnR[i]->move(r.width() - (d_nButtons - i) * btnWidth, 0);
		btnL[i]->show();
		btnR[i]->show();
	}
	
	for (i=d_nButtons; i<MAXBTNS; i++)
	{
		btnL[i]->hide();
		btnR[i]->hide();
	}

	lblValue->resize(r.width() - 2*d_nButtons * btnWidth, r.height());
	lblValue->move(d_nButtons * btnWidth, 0);

}

QwtCounter::~QwtCounter()
{
	delete btnL[0];
	delete btnL[1];
	
	delete btnR[0];
	delete btnR[1];
	
	delete lblValue;
}

void QwtCounter::setBigInc(int n)
{
	d_Inc[1] = n;
}

void QwtCounter::valueChange()
{
	lblValue->setNum(value());
	emit valueChanged(value());
}

void QwtCounter::setCounterStyle(CounterStyle s)
{

	if ((s >= Single) && (s <= Triple))
	   d_nButtons = s;
	resize(size());
}

void QwtCounter::btnL1Dn()
{
	if (tmrID) killTimer(tmrID);
	d_tick = 0;
	d_incValue = -d_Inc[0];
	tmrID = startTimer(d_tmrIntv);
}

void QwtCounter::btnL2Dn()
{
	if (tmrID) killTimer(tmrID);
	d_tick = 0;
	d_incValue = -d_Inc[1];
	tmrID = startTimer(d_tmrIntv);
}

void QwtCounter::btnL3Dn()
{
	if (tmrID) killTimer(tmrID);
	d_tick = 0;
	d_incValue = -d_Inc[2];
	tmrID = startTimer(d_tmrIntv);
}


void QwtCounter::btnR1Dn()
{
	if (tmrID) killTimer(tmrID);
	d_tick = 0;
	d_incValue = d_Inc[0];
	tmrID = startTimer(d_tmrIntv);
}

void QwtCounter::btnR2Dn()
{
	if (tmrID) killTimer(tmrID);
	d_tick = 0;
	d_incValue = d_Inc[1];
	tmrID = startTimer(d_tmrIntv);
}

void QwtCounter::btnR3Dn()
{
	if (tmrID) killTimer(tmrID);
	d_tick = 0;
	d_incValue = d_Inc[2];
	tmrID = startTimer(d_tmrIntv);
}

void QwtCounter::btnUp()
{
	if (!d_tick)
	{
		incValue(d_incValue);
		d_tick = 0;
	}
	if (tmrID) killTimer(tmrID);
}

void QwtCounter::timerEvent(QTimerEvent *e)
{
	d_tick = 1;
	incValue(d_incValue);
}

