/**************************************************************************
 * $Id: script_all.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef _script_all
#define _script_all

#ifndef TRUE
#define TRUE (1==1)
#endif

#ifndef FALSE
#define FALSE (1==0)
#endif

#define SWAP_32_ENDIAN(a) {                                                  \
        u_int32_t _tmp = a;                                             \
        ((char *)&a)[0] = ((char *)&_tmp)[3];                           \
        ((char *)&a)[1] = ((char *)&_tmp)[2];                           \
        ((char *)&a)[2] = ((char *)&_tmp)[1];                           \
        ((char *)&a)[3] = ((char *)&_tmp)[0];                           \
}


#define WIDGET_TEXT 1
#define WIDGET_INPUT 2
#define WIDGET_BUTTON 3
#define WIDGET_SWITCH 4
#define WIDGET_LCD 5
#define WIDGET_LED 6
#define WIDGET_FRAME 7
#define WIDGET_INPUTA 8
#define WIDGET_LEDA 9
#define WIDGET_SELECT 10
#define WIDGET_WHEEL 11
#define WIDGET_GRAPH 12
#define WIDGET_KNOB 13
#define WIDGET_LEVEL 14
#define WIDGET_SLIDER 15

#include <qlist.h>
#include <qwt.h>

enum error {  
   FATAL,ERROR,WARNING,NOTE,DIAGNOSTIC 
}; 

enum states {    /* current state of program */
   HATCHED,INITIALIZED,COMPILING,COMPILED,RUNNING,STOPPED,FINISHED
};


/* ------------- global types ---------------- */ 
   
   struct stackentry { /* one element on stack */ 
      int type;     /* contents of entry */
      struct stackentry *next;
      struct stackentry *prev;
      void *pointer; /* multiuse ptr */
      double value;  /* double value, only one of pointer or value is used */
      void *wpointer;
   };
   
   struct symbol {   /* general symbol; either variable, string, label or call */
      int type;
      struct symbol *next;
      char *name;
      void *pointer;   /* general pointer */
      char *args;      /* used to store number of arguments for functions/array */
      double value;
   };
   
   struct command { /* one interpreter command */
      int type;    /* type of command */
      struct command *next;  /* link to next command */
      void *pointer;       /* pointer to command specific alloc data */
      void *spointer; /* static pointers */
      void *spointer2;
      void *pointer2;
      int args;  /* number of arguments for function/array call */
      /* or stream number for open/close             */
      char tag;  /* letter to pass some information */
      int line; /* line this command has been created for */
      int arg1,arg2,arg3;
   };
   
   struct array { /* data structure for arrays */
      int bounds[10];  /* index boundaries */
      int dimension; /* dimension of array */
      int total; /* product of all dimensions */
      int dimed;      /* Flag to mark if array has been dimed already */
      void *pointer; /* contents of array */
      char type;  /* decide between string- ('s') and double-Arrays ('d') */
   };

typedef struct {
   char *text;
   char *color;
   char *action;
   int prec, modif;
   int type;
   int x,y,w,h;
   int style;
   int linewidth;
   char **transfer;
   double *value;
   int active;
   int count;
   double from, to, step, angle;
   void *pointer;
} widgetitem;

class ScriptDlg;

typedef struct {
   char *name;
   char *title;
   ScriptDlg *dlg;
   QList<widgetitem> *widgets;
} dlgitem;


#endif
