/**************************************************************************
 * $Id: About.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include <samplin.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <stdlib.h>
#include <qtimer.h>
#include "About.h"

#include "About.moc"

SamplinAbout::SamplinAbout( QWidget *parent, const char *name, bool timed ) 
	: QDialog( parent, name, TRUE )
{
   setCaption( "About SampLin" );
   setFixedSize( 400, 200 );
   iLoader = new KIconLoader();
   setIcon(iLoader->loadIcon("SampLin.xpm"));
   iLoader->insertDirectory(0,QString("./Icons/"));
   setBackgroundPixmap(iLoader->loadIcon("SampLin.bmp") );
   drawIt();
   
   if ( timed )  {
      QTimer *timer = new QTimer( this );
      timer->start( 1000, TRUE );
      connect( timer, SIGNAL(timeout()), SLOT(accept()) );
   }
	
}

SamplinAbout::~SamplinAbout()
{	
   delete iLoader;
}

void SamplinAbout::mousePressEvent( QMouseEvent *e )
{
	QRect r( 0, 0, 400, 200 );
	if ( r.contains( e->pos() )	) accept();		 
}


void SamplinAbout::paintEvent( QPaintEvent * )
{
drawIt();
}

void SamplinAbout::drawIt()
{
QFont f( "helvetica", 10 );
QPainter p;
p.begin( this );
p.setFont( f );
   p.drawText(20,125,QString("SampLin data acquisition software, version ")+SAMPLIN_VERSION);
   p.drawText(20,145,"Copyright (c) 1998 Samuel Kvasnica, IAEE TU-WIEN");
   p.drawText(20,165,"Email: kvasnica@iaee.tuwien.ac.at");
   p.drawText(20,185,"This software may be distributed under the terms of GPL");
   p.end();
}
