/**************************************************************************
 * $Id: main.cpp 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/
#include "SamplinMain.h"
#include "main.h"
#include "About.h"
#include <script.h>

struct configstruct cnf;
//SamplinCurve *clipboard_curve;

main( int argc, char ** argv )
{
   QFile testfile;
   Samplin_main *iw;
   SamplinScript *compiler;
   int ret;
   
   clipboard_curve=NULL;
   
   if(argc>2){
      printf("SampLin %s\nSyntax:main [sccriptname]\n", SAMPLIN_VERSION);
      exit(0);
   }
     
   KApplication a( argc, argv );

   readConfig();
   writeConfig();
   createDirs();
   
   if(argc==2){
      QString openfile(argv[1]);

      testfile.setName(openfile);
      if(testfile.exists()==FALSE){
	 openfile+=SCRIPT_EXT;
	 testfile.setName(openfile);
	 if(testfile.exists()==FALSE){
	    openfile=cnf.root_dir+cnf.scripts_dir+argv[1];
	    testfile.setName(openfile);
	    if(testfile.exists()==FALSE){
	       openfile+=SCRIPT_EXT;
	       testfile.setName(openfile);
	       if(testfile.exists()==FALSE){
		  QMessageBox::warning(NULL,"Error","Can't open script file");
		  exit(1);  
	       }
	    }
	 }
      }
      compiler = new SamplinScript(NULL);
      compiler->setDevicesFile(cnf.cnf_dir+cnf.devices_file);
      compiler->setQuitFlag(TRUE);
      //      compiler->setGraphlist();
      if((compiler->compile(openfile))==0)
	compiler->go(-1);
      else exit(2);
   }
   else {

      SamplinAbout about;
      about.show();
      iw = new Samplin_main();
      iw->setMinimumSize(400,88);
      iw->show();
      a.setMainWidget(iw);      
   }

   ret=a.exec();
   return ret; 
}
   
void createDirs(void)
{
   QString kstr,rstr;
   
   kstr=kapp->localkdedir().copy()+"/share/apps";
   
   QDir kdir(kstr);
   if(kdir.exists()==FALSE){
      QMessageBox::information(NULL,"Information","SampLin will create directory "+kstr);
      kdir.mkdir(kstr);
   }

   kstr+="/"+kapp->appName().copy()+"/";
   kdir.setPath(kstr);
   if(kdir.exists()==FALSE){
     QMessageBox::information(NULL,"Information","SampLin will create directory "+kstr);
     kdir.mkdir(kstr);
   }
  
   cnf.cnf_dir=kstr;
   
   rstr=cnf.root_dir;
   
   QDir rdir(rstr);
   if(rdir.exists()==FALSE){
      QMessageBox::information(NULL,"Information","SampLin will create base directory "+rstr);
      rdir.mkdir(rstr);
   }
   
   QDir datadir(rstr+cnf.data_dir);
   if(datadir.exists()==FALSE){
     QMessageBox::information(NULL,"Information","SampLin will create data directory "+rstr+cnf.data_dir);
     datadir.mkdir(rstr+cnf.data_dir);
   }
   
   QDir scriptsdir(rstr+cnf.scripts_dir);
   if(scriptsdir.exists()==FALSE){
     QMessageBox::information(NULL,"Information","SampLin will create script directory "+rstr+cnf.scripts_dir);
     scriptsdir.mkdir(rstr+cnf.scripts_dir);
   }
   
}

void writeConfig(void)
{
   KConfig *config;
   config=kapp->getConfig();
   
   config->setGroup("Directories");
   config->writeEntry("root_dir",cnf.root_dir);
   config->writeEntry("data_subdir",cnf.data_dir);
   config->writeEntry("scripts_subdir",cnf.scripts_dir);
   config->writeEntry("devices_file",cnf.devices_file);
   
   config->setGroup("Interpreter");
   config->writeEntry("info_level",cnf.info_level);
   config->writeEntry("mesg_window",cnf.mesg_win);
   
   config->setGroup("Editor");
   config->writeEntry("external_editor",cnf.ext_editor);
   config->writeEntry("editor_command",cnf.edit_command);
   
   config->sync();
}

void readConfig(void)
{
   KConfig *config;
   config=kapp->getConfig();
   
   config->setGroup("Directories");
   cnf.root_dir=config->readEntry("root_dir",QDir::homeDirPath()+"/SampLin/");
   cnf.data_dir=config->readEntry("data_subdir","Data/");
   cnf.scripts_dir=config->readEntry("scripts_subdir","Scripts/");
   cnf.devices_file=config->readEntry("devices_file",DEVICES_FILE);
   
   config->setGroup("Interpreter");
   cnf.info_level=config->readNumEntry("info_level",WARNING);
   cnf.mesg_win=config->readNumEntry("mesg_window",TRUE);
   
   config->setGroup("Editor");
   cnf.ext_editor=config->readNumEntry("external_editor",FALSE);
   cnf.edit_command=config->readEntry("editor_command","xterm -e jed %f");
}
