/**************************************************************************
 * $Id: devices.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SAMPLIN_DEVICES_included
#define SAMPLIN_DEVICES_included

#define DEVICE_VOID 0
#define DEVICE_GPIB 1
#define DEVICE_SERIAL 2

#define GPIB_DVRSP 1

#define ENDIAN_BIG 0
#define ENDIAN_LITTLE 1

#define DEF_DELAY 0

#include <qstring.h>
#include <qdatastream.h>
#include <qlist.h>

#include <rpc/rpc.h>
#include <termios.h>
#include <errno.h>

class SamplinDevice
{
public:
   SamplinDevice( void );
   virtual ~SamplinDevice();
   
   virtual int Open(void);
   virtual int Close(void);
   virtual int Read(char *ptr,const int len, const int binary);
   virtual int Write(const char *ptr, const int len, const int binary);
   virtual int Ready(void);
   virtual int Ioctl(int req,long arg);
   virtual int GpibFunc(int req);
   
   void   setEndian( const int val ){ endian=val; }
   const int   getEndian( void ){ return(endian); }
   void   setDelay( const int val ){ delay=val; }
   const int   getDelay( void ){ return(delay); }
   void   setSpeed( int val ){ serial_speed=val; }
   const int getSpeed( void ){ return(serial_speed); }
   void   setDatabits( const int i ){ serial_data=i; }
   const int   getDatabits( void ){ return(serial_data); }
   void   setStopbits( const int i ){ serial_stop=i; }
   const int   getStopbits( void ){ return(serial_stop); }   
   void   setParity( const int i ){ serial_parity=i; }
   const int   getParity( void ){ return(serial_parity); }      
   void   setType( const int typ ){ type=typ; }
   const int   getType( void ){ return(type); }
   void   setName( const char *str ){ name=str; }
   const char   *getName( void ){ return(name); }
   void   setTitle( const char *str ){ title=str; }
   const char   *getTitle( void ){ return(title); }   
   void   setPath( const char *str ){ path=str; }
   const char   *getPath( void ){ return(path); }   
   void   setHost( const char *str ){ host=str; }
   const char   *getHost( void ){ return(host); }      
   void   setFlags( const int f ){ flags=f; }
   const int   getFlags( void ){ return(flags); }         
   const bool isOpen(void){return(handle!=0);};
   void   setTimeout( const int t ){ timeout=t; }
   const int   getTimeout( void ){ return(timeout); }         
   void   setNTimeout( const int t ){ ntimeout=t; }
   const int   getNTimeout( void ){ return(ntimeout); }            

   const char *getErrorLog(void){return(errlog.data());}

   void   setInit( const char *str ){ gpib_init=str; }
   const char   *getInit( void ){ return(gpib_init); }         
   void   setAddress( const int t ){ gpib_address=t; }
   const int getAddress( void ){ return(gpib_address); }      
   void   setEos( const char t ){ gpib_eos=t; }
   const char getEos( void ){ return(gpib_eos); }         
   void   setDcl( const char t ){ gpib_dcl=t; }
   const char getDcl( void ){ return(gpib_dcl); }            
   void   setLlo( const char t ){ gpib_llo=t; }
   const char getLlo( void ){ return(gpib_llo); }         
   void   setMaster( const char t ){ gpib_master=t; }
   const char getMaster( void ){ return(gpib_master); }         
   
   SamplinDevice &operator=(SamplinDevice &);
   
 protected:

   QString name, title, path, host, errlog, gpib_init;
   int handle,type,endian,delay, flags, serial_data, serial_stop, serial_parity;
   int serial_speed,timeout,ntimeout, gpib_address;
   char gpib_eos, gpib_dcl, gpib_llo,gpib_master;
   
   CLIENT *rhandle;
   
};

QDataStream &operator<<( QDataStream &, SamplinDevice &);
QDataStream &operator>>( QDataStream &, SamplinDevice &);
bool  operator==(SamplinDevice &, SamplinDevice &);
bool  operator!=(SamplinDevice &, SamplinDevice &);

QDataStream &operator>>( QDataStream &s, QList<SamplinDevice> &devs);
QDataStream &operator<<( QDataStream &s, QList<SamplinDevice> &devs);

#endif // SAMPLIN_DEVICES_included
