/**************************************************************************
 * $Id: script.h 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef __INCL_SCRIPT
#define __INCL_SCRIPT

#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <string.h>
#include <math.h>
#include <time.h>

#include <unistd.h>
#include <signal.h>
#include <ctype.h>


#define DONE {current=current->next;break;}

#include <qintdict.h>
#include <qlist.h>
#include <qobject.h>
#include <qtimer.h>
#include <kledlamp.h>
#include <qlcdnum.h>
#include <qprogressdialog.h>

#include <samplin.h>
#include "../ui/edit.h" // !!!!!!!!!!!!
#include <devices.h>
#include <ScriptInput.h>
#include <GraphWindow.h>
#include "script.flex.h"
#include "script.bison.h"
#include "script_all.h"


void signal_handler(int);  /* handle various signals */

/* ------------- flex ------------------------ */
void yyerror(char *); /* yyerror message */


class SamplinScript : public QObject, public SamplinParser
{
   Q_OBJECT

 public:
   
   
   SamplinScript(QWidget *parent=0);
   virtual ~SamplinScript();

   int yylex();
   void yyerror(char *);
   void setDevicesFile(const char *);
   void setInfoLevel(int level){infolevel=level;}
   void setQuitFlag(bool qflag){quitflag=qflag;}

   dlgitem *findDlg(const char *name);
   GraphPanel *findGraph(const char *name);
   GraphWindow *findGraphWindow(const char *name);
   GraphWindow *findGraphWindow(uint id);
   uint newGraphId(void);
   GraphWindow *openGraph(const char *name);
   bool closeGraph(const char *name);
   bool closeGraph(uint id);
   bool closeAllGraphs(void);
   
   void widgetAction(void);
   void timeHandler(void);
   
   SamplinDevice *getDevice(char *);
   void closeDevices(void);
   
   SamplinScanner *scanner;
   QList<SamplinDevice> *devices;
   QIntDict<GraphWindow> graphs;
   QList<dlgitem> dialogs;
   QProgressDialog *pd;
   
   QString devices_file, script_file;
   bool quitflag;

   /* ---------------------- enum types ------------------------------- */
   
   enum stck_or_sym { /* contents of a stack element or type of a symbol */
      STRING,NUMBER,LBL,GTO,JUMP,FREE,FUNC,ARRAY,RETADD,IRETADD,PTR,NIL
   };
   
   enum cmd_type { /* type of command */
      LABEL,GOTO,QGOTO,GOSUB,QGOSUB,IGOSUB,RETURN,          /* flow control */
      END,DECIDE,SKIPPER,NOP,
      
      DIM,FUNCTION,DOARRAY,                          /* everything with "()"*/
      
      DBLADD,DBLMIN,DBLMUL,DBLDIV,DBLPOW,NEGATE,     /* double operations */
      DBLAND,DBLXOR,DBLOR,
      PUSHDBLSYM,POPDBLSYM,PUSHDBL,
      
      SETINFOLEVEL,

      AND,OR,NOT,LT,GT,LE,GE,EQ,NE,STREQ,STRNE,      /* comparisons */
      
      PUSHSTRSYM,POPSTRSYM,PUSHSTR,CONCAT,           /* string operations */
      
      PRINT,MYREAD,PROMPT,RESTORE,QRESTORE,          /* i/o operations */
      READDATA,DATA,MYOPEN,MYCLOSE,MYSWITCH,
      WAIT,BELL,
      
      DEVWR, DEVWRB, DEVRD, DEVRDB, DEVOPEN, DEVCLOSE, DEVCTL,

      MESSAGE, ADDPLOT, UPDATEPLOT, DELPLOT, 
      
      ADDGRAPH, DELGRAPH, LOADGRAPH, SAVEGRAPH, TITLEGRAPH, PLOTFNC, GRAPHFNC,

      ADDDLG, DELDLG, HIDEDLG, SHOWDLG, PROGRESSDLG, ADDWIDGET,
      
      SLEEP, MULTI, CURSOR, TIMER
   };
   
   enum states {    /* current state of program */
      HATCHED,INITIALIZED,COMPILING,COMPILED,RUNNING,STOPPED,FINISHED
   };
   
   /* ------------- function prototypes for ... ---------------- */
   /* ------------- main program and auxiliary functions ---------------- */

   int programState(void);
   int errorLevel(void){return errorlevel;}
   int currentLine(void);
   int doStep(void);
   int compile(const char *);
   void go(int line);
   void reset(void);
   void step(void);
   void setMsgwin(Edit *ptr);
   void freeAlloc(void);
   //     {msgwin=ptr;if(ptr!=NULL)ptr->clear();printf("ddd\n");}
   
   struct symbol *get_sym(const char *,int,int); /* find and/or add a symbol */
   struct command *add_command(int); /* get room for new command */
   void initialize(void); /* give correct values to pointers etc ... */
   void resetptr(void); /* reset pointers to their initial values */

   void error(int,const char *); /* reports an error and possibly exits */
   void uif(int); /* issues warning on screen */
   char *my_strdup(const char *); /* my own version of strdup */
   void *my_malloc(unsigned); /* my own version of malloc */
   
   /* ------------- double handling ---------------- */
   void create_negate(void); /* creates command negate */
   void negate(void);  /* negates top of stack */
   void create_pushdblsym(char *); /* create command 'pushdblsym' */
   void pushdblsym(struct command *); /* push double symbol onto stack */
   void create_popdblsym(char *); /* create command 'popdblsym' */
   void popdblsym(struct command *); /* pop double from stack */
   void create_pushdbl(double); /* create command 'pushdbl' */
   void pushdbl(struct command *); /* push double onto stack */
   void create_dblbin(char); /* create binary expression calculation */
   void dblbin(struct command *); /* compute with two numbers from stack */
   void create_dblrelop(char); /* create command dblrelop */ 
   void dblrelop(struct command *);  /* compare topmost double-values */
   
   /* ------------- string handling ---------------- */
   void create_pushstrsym(char *); /* push string symbol onto stack */
   void pushstrsym(struct command *);   /* push string symbol onto stack */
   void create_popstrsym(char *); /* create command 'popstrsym' */
   void popstrsym(struct command *); /* pop string from stack */
   void create_concat(void); /* creates command concat */
   void concat(void); /* concetenates two strings from stack */
   void create_pushstr(char *); /* creates command pushstr */
   void pushstr(struct command *); /* push string onto stack */
   void pushname(char *); /* push a name on stack */
   void create_strrelop(char); /* create command strrelop */ 
   void strrelop(struct command *);  /* compare topmost string-values */
   
   /* ------------- i/o ---------------- */
   void create_print(char); /* create command 'print' */
   void print(struct command *); /* print on screen */
   char *replace(char *); /* replace \n,\a, etc. */
   void create_myread(char); /* create command 'read' */
   void myread(struct command *); /* read from file or stdin */
   void create_prompt(char *); /* create command 'prompt' */
   void prompt(struct command *); /* set input prompt */
   void create_myopen(double,char *); /* create command 'myopen' */
   void myopen(struct command *); /* open specified file for given name */
   void create_myclose(double); /* create command 'myclose' */
   void myclose(struct command *); /* close the specified stream */
   void create_myswitch(double); /* create command 'myswitch' */
   void myswitch(struct command *); /* switch to specified stream */
   int badstream(int); /* test for valid stream id */
   
   /* ------------- flow--control ---------------- */
   void create_goto(char *); /* creates command goto */
   void create_gosub(char *); /* creates command gosub */
   void create_label(char *); /* creates command label */
   void pushgoto(void); /* generate label and push goto on stack */
   void popgoto(void); /* pops a goto and generates the matching command */
   void jump(struct command *); /* jump to specific Label */
   void create_return(void); /* creates command return */
   void myreturn(void); /* return from gosub */
   void create_skipper(void); /* creating command skipper */
   void skipper(void); /* used for on_goto/gosub, skip commands */
   void create_nop(void); /* does nothing */
   void create_myend(void); /* create command 'end' */
   void myend(void); /* is called at the end of program execution */
   void create_decide(void); /* creates command decide */
   void decide(void); /*  skips next command, if 0 on stack */
   
   /* ------------- miscellanous basic commands ---------------- */
   void create_boole(char); /* create command boole */ 
   void boole(struct command *);  /* perform and/or/not */
   void create_function(int,char *); /* create command 'function' */
   void function(struct command *); /* performs a function */
   void create_doarray(char *,int); /* creates array-commands */ 
   void doarray(struct command *);  /* call an array */
   void create_dim(char *,char); /* create command 'dim' */
   void dim(struct command *); /* get room for array */
   void create_restore(char *); /* create command 'restore' */
   void restore(struct command *); /* reset data pointer to given label */
   void create_dbldata(double);  /* create command dbldata */
   void create_strdata(char *);  /* create command strdata */
   void create_readdata(char); /* create command readdata */
   void readdata(struct command *); /* read data items */
   void create_mywait(); /* create Command 'wait' */
   void mywait(); /* wait given number of seconds */
   void create_bell(); /* create Command 'bell' */
   void bell(); /* ring ascii bell */
   void setinfolevel(void); /* set infolevel to content of variable */
   

   /* ------------- basic functions ---------------- */

   char *fromto(char *,int,int); /* portion of string (for mid$,left$,right$) */
   char *inkey(void); /* gets char from keyboard, blocks and doesnt print */


   /* ------------- other stack operations ---------------- */
   void pushcopy(void); /* push copy of the last stack element */
   void pushcounter(void); /* push number '0' on stack */
   void inccounter(void); /* increment topmost stack element */
   void pushletter(char *); /* push letter on stack (for argument test) */
   void pushlabel(void); /* generate goto and push label on stack */
   void poplabel(void); /* pops a label and generates the matching command */
   void swap(void); /*swap topmost elements on stack */
   struct stackentry *push(void); /* push element on stack and enlarge it*/
   struct stackentry *pop(void); /* pops element to memory */
   struct array * plotArrayOk(const char *astr);
   
   void create_message(char);
   void message(struct command *);

   void create_devopen(char *);
   void devopen(struct command *);

   void create_devclose(char *);
   void devclose(struct command *);
   
   void create_devwr(char *,int);
   void devwr(struct command *);

   void create_devwrb(char *, char *);
   void devwrb(struct command *);
   
   void create_devrd(char *,int);
   void devrd(struct command *);
   
   void create_devrdb(char *, char *);
   void devrdb(struct command *);

   void create_devctl(char *);
   void devctl(struct command *);
   
   void create_plotfnc(int, char *, char *);
   void plotfnc(struct command *);
   
   void create_graphfnc(int, int, char *, char *);
   void graphfnc(struct command *);
   
   void create_addplot(int, char *, char *);
   void addplot(struct command *);

   void create_updateplot(int, char *, char *);
   void updateplot(struct command *);

   void create_delplot();
   void delplot(struct command *);
   
   void create_addgraph();
   void addgraph(struct command *);

   void create_delgraph();
   void delgraph(struct command *);

   void create_loadgraph(int);
   void loadgraph(struct command *);
   
   void create_savegraph(int);
   void savegraph(struct command *);   

   void create_exportgraph(int);
   void exportgraph(struct command *);      

   void create_printgraph();
   void printgraph(struct command *);   
   
   void create_titlegraph();
   void titlegraph(struct command *);
   
   void create_adddlg(char *);
   void adddlg(struct command *);

   void create_progressdlg(int, int);
   void progressdlg(struct command *);
   
   void create_deldlg(char *);
   void deldlg(struct command *);

   void create_hidedlg(char *);
   void hidedlg(struct command *);
   
   void create_showdlg(char *);
   void showdlg(struct command *);
   
   void create_addwidget(char *, int, char *, char *);
   void addwidget(struct command *);
   
   void create_mysleep(); /* create Command 'wait' */
   void mysleep(); /* wait given number of seconds */   

   void create_multi(int);
   void multi(struct command *);
   
   void create_timer(int);
   void mytimer(struct command *);   

   void create_cursor(int);
   void cursor(struct command *);   
   /* ------------- global variables ---------------- */
   
   struct symbol *symroot; /* first element in symbol list */
   struct symbol *symhead; /* last element ind symbol list */
   struct stackentry *stackroot; /* lowest element in double stack */
   struct stackentry *stackhead; /* topmost element in double stack */
   struct command *current; /* currently executed command */
   struct command *cmdroot; /* first command */
   struct command *cmdhead; /* last command */
   struct command *datapointer; /* current location for read-command */
   int infolevel; /* controls issuing of error messages */
   int diagnostic_count; /* number of diagnostic messages */
   int note_count; /* number of notes */
   int warning_count; /* number of warning messages */
   int error_count; /* number of error messages */
   int interactive; /* true, if commands come from stdin */
   char *string; /* for trash-strings */
   int labelcount; /* count self-generated labels */
   int commandcount; /* total number of commands */
   int program_state;  /* state of program */
   char inputprompt[100]; /* input prompt */
// !!!   struct command *lastcommand; /* most recently created command */
   FILE *streams[10]; /* file streams */
   FILE *currentstream; /* current stream for output ... */
   
   /* printer-related */
   FILE *printerfile; /* file to print on */
   char *prfilename; /* filename to print on */
   int print_to_file; /* print to file ? */

 public slots:
   void stop();
   void widgetSlot(widgetitem *w);
   void closeGraphSlot(uint id);
   void progressSlot();
 protected slots:
   void stepHandler();
   void crashHandler();
   void pauseSlot();
  
 private:
   void setProgramState(int state);
   
 private:
   QTimer *timer;
   Edit *msgwin;
   bool showmsg;
   bool multiflag;
   bool timerflag;
   int  delaylen;
   int  last_print;
   
   widgetitem *waitMulti;
   int task_cnt;
   int goto_line,last_line;
   bool step_flag;
   
 signals:
   void refreshParent();
   void finishedScript();
   void changedState(int);
   void openGraphSignal(uint id, GraphWindow *gwin);
   void closeGraphSignal(uint id);   
//   void closeGraph(char *);
};

#endif
