/***************************************************************************
                          Labels.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include "Labels.h"

Labels::Labels
(
	QWidget *_parent,
	const QString& name
)
: QLabel (_parent,name)
{
	parent = _parent;
	this->setFocusPolicy( QWidget::NoFocus );
	this->setBackgroundMode( QWidget::PaletteBackground );
	this->setFontPropagation( QWidget::NoChildren );
	this->setPalettePropagation( QWidget::NoChildren );
	this->setFrameStyle( 0 );
	this->setLineWidth( 0 );
	this->setMidLineWidth( 0 );
	this->QFrame::setMargin( 0 );
	this->setText( name );
/*	this->setAlignment( 1289 );*/
	this->setAlignment( 265 );
	this->setMargin( -1 );
	setMouseTracking(TRUE);
	this->show();
	connect(this, SIGNAL(signal_labels_mousePressEvent()), parent, SLOT(slot_kcard_mousePressEvent()));
	connect(this, SIGNAL(signal_labels_mouseDoubleClickEvent()), parent, SLOT(slot_kcard_mouseDoubleClickEvent()));
}


Labels::~Labels()
{
}

//SLOTS

void Labels::changepalette(int this_int)
{
QColorGroup normal	=	QColorGroup ( QColor( QRgb(10789024) ), QColor( QRgb(16777215) ), QColor( QRgb(16777215) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
QColorGroup select	=	QColorGroup ( QColor( QRgb(8421504) ), QColor( QRgb(8388608) ), QColor( QRgb(16777215) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(16777215) ), QColor( QRgb(12632256) ) );
QColorGroup active	=	QColorGroup ( QColor( QRgb(0) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
	
QPalette palette_normal = QPalette ( normal, select, active );
QPalette palette_select = QPalette ( select, normal, active);
QPalette palette_active = QPalette ( active, select, normal);

switch (this_int)
{
	case 1 : 
		{
		this->setPalette(palette_normal);
		break;
		}
	case 2 : 
		{
		this->setPalette(palette_select);
		break;
		}
	case 3 : 
		{
		this->setPalette(palette_active);
		break;
		}
	}
}

void Labels::changetext(QString this_string)
{

this->setText(this_string);
}

void Labels::changefont(int this_int)
{
QFont font1( "helvetica", 14, 50, 0 );
font1.setStyleHint( (QFont::StyleHint)0 );
font1.setCharSet( (QFont::CharSet)0 );

QFont font2( "helvetica", 12, 50, 1 );
font2.setStyleHint( (QFont::StyleHint)0 );
font2.setCharSet( (QFont::CharSet)0 );

switch (this_int)
	{
	case 1 :
		{
		this->setFont(font1);
		break;
		}
	case 2 :
		{
		this->setFont(font2);
		break;
		}
	}
}


//Mouse && Events
void Labels::mousePressEvent(QMouseEvent *e)
{
emit signal_labels_mousePressEvent();
}

void Labels::mouseDoubleClickEvent(QMouseEvent *e)
{
emit signal_labels_mouseDoubleClickEvent();
}

bool Labels::startswith(char this_char)
{
QString temp;
temp=this->text();
if ((temp.find(this_char,0)==0)||(temp.find(toupper(this_char),0)==0)) {return (true);}
else {return(false);}
}
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
