/* stockinfo.h
 *
 * Andreas Wst
 *
 */

#ifndef STOCKINFO_H
#define STOCKINFO_H

#include <qdialog.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qlistview.h>
#include <qframe.h>
#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qregexp.h>

#include <kmsgbox.h>

//#include "stockdata.h"

#include "stock.h"
#include "structs.h"

class StockInfo : public QDialog
{

  Q_OBJECT

public:

  StockInfo ( QWidget *, const char *name, int);
  ~StockInfo();

public slots:

   
  // startet browser mit entsprechender seite
  void startBrowser (int);

  // stock news at zacks
  void openBrowserWithZacks ();

  // Stock quotes cnnfn
  void openBrowserWithCNNFN ();

  // CBS Market Watch -> NEWS
  void openBrowserWithCBSMarketWatchNews ();

  // CBS Market Watch -> HOME
  void openBrowserWithCBSMarketWatchHome ();

  // YAHOO GRADES 
  void openBrowserWithYahooGrades ();

  // QUICKEN HOME 
  void openBrowserWithQuickenQuote ();

  // QUICKEN SNAPSHOT
  void openBrowserWithQuickenSnapshot ();

  // YAHOO HOME -> Netscape mit auf Krzelseite ffnen
  void openBrowserWithYahooHome ();

  // popup dialog fr aktien in listview
  void openPopupInListView (QListViewItem *, const QPoint &, int);
 

  // erhlt aktuelles listviewitem
  void getCurrentItem (QListViewItem *);


private:
  
  QPushButton *ok;
  QListView *lv;
  QFrame *fr;

protected:

  struct CONFIGURATION_DATA config_data;

  void loadList ();
  Stock *currentStock;
  QPopupMenu *popyahoo, *popcbs, *popquicken, *popup;
   
};

#endif		
