/* config_dialog.cpp
 *
 * Andreas Wst
 *
 */ 

#include "config_dialog.moc"

ConfigDialog::ConfigDialog ( QWidget *parent, const char *name, 
            struct CONFIGURATION_DATA *c )
                : QDialog ( parent, name, TRUE)
{
  conf = c;

  setCaption ("KStocks Configuration");

  tabdialog = new QTabDialog (this, "tabdialog");
  tabdialog->setGeometry (5, 5, 325, 400);
  tabdialog->setCancelButton ();
  connect (tabdialog, SIGNAL(applyButtonPressed ()), SLOT(okPressed ()));
  connect (tabdialog, SIGNAL(cancelButtonPressed ()), SLOT(cancelPressed ()));

  da = new DayAverage (this, "dayaverage", conf->col1, conf->col2, conf->col3);
  da->setGeometry (5, 5, 250, 250);

  br = new Browser (this, "browser");
  br->setGeometry (5, 5, 250, 250);
  br->setIndex (conf->browser);

  tabdialog->addTab (da, "Day-Average");
  tabdialog->addTab (br, "Browser");

  resize ( 340, 410);
}

void ConfigDialog::okPressed ()
{
  // alle configwerte bernehmen und dialog beenden
  debug ("ok pressed");
  switch (br->getIndex ())
  {
    case 0 : debug ("netscape");           
             break;
    case 1 : debug ("kfm");
             break;
    case 2 : debug ("opera");
             break;
  }
  // neuen browser in config_data setzen
  conf->browser = br->getIndex ();

  // neue Farbewerte aus dialog holen, wenn ok
  da->getColors (conf->col1, conf->col2, conf->col3);
  
  accept ();
}

void ConfigDialog::cancelPressed ()
{
  // dialog beenden
  debug ("cancel pressed ");
  reject ();
}


ConfigDialog::~ConfigDialog()
{
}
