
#include <qmessagebox.h>
#include <kmsgbox.h>
#include <kconfig.h>
#include <kprocess.h>
#include <stdlib.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "ksiag_app.h"
#include "ksiag_dialogs.h"
#include "plugincallbacks.h"
#include "formcallbacks.h"
#include "siagcallbacks.h"

extern char *colors[];
extern int fontsizes[];
extern char *fonts[];

extern "C"{
window *w_list;
int pr_scr_flag;
extern int recalc;
int input_warp_pointer = 1;
int macro_flag;
textbuf kbd_macro = {0, 0, 0};
}

enum {ABORT=0, DONE, WAITING};
extern bool use_lineedit;

void interp_startup()
{
    init_subr_0("get-geometry", get_geometry);
    init_subr_0("set-block", set_block);
    init_subr_0("unset-block", unset_block);
    init_subr_0("new-buffer", new_empty_buffer);
    init_subr_0("kill-current-buffer", kill_current_buffer);
    init_subr_0("new-window", new_toplevel_window);
    init_subr_0("fit-block-width", fit_block_width);
    init_subr_0("fit-block-height", fit_block_height);
    init_subr_0("copy-block", copy_block);

    // Embedding, plugins, and forms are not yet supported :-(
    init_subr_0("embed-object", embed_unsupported);
    init_subr_0("embed-remove", embed_unsupported);
    init_subr_0("embed-open", embed_unsupported);
    init_subr_0("embed-save", embed_unsupported);
    init_subr_3("plugin-register", plugin_register);
    init_subr_1("plugin-add", plugin_add);
    init_subr_0("plugin-import", plugin_import);
    init_subr_0("plugin-export", plugin_export);
    init_subr_0("plugin-link", plugin_link);
    init_subr_0("plugin-delete", plugin_delete);
    init_subr_0("plugin-move", plugin_move);

    init_subr_0("form-begin", form_begin);
    init_subr_1("form-label", form_label);
    init_subr_1("form-text", form_text);
    init_subr_1("form-menu", form_menu);
    init_subr_1("form-menuentry", form_menuentry);
    init_subr_1("form-okbutton", form_okbutton);
    init_subr_1("form-cancelbutton", form_cancelbutton);
    init_subr_2("form-property", form_property);
    init_subr_0("form-newline", form_newline);
    init_subr_0("form-end", form_end);
}

void init_windows1 (int *argc, char **argv)
{
    new KSiagApp(*argc, argv);
    KSiagApp::log()->exec();
}

void init_windows (buffer *b, int argc, char **argv)
{
    activate_window(new_window(b, 0));
    init_subr_3("add-menu-entry", add_menu_entry);
    init_subr_2("add-submenu", add_submenu);
    init_subr_4("add-submenu-entry", add_submenu_entry);
    init_calc_cmds();
    
}
    
void mainloop()
{
    warning("KSiag: mainloop called");
    QFileInfo info(QDir::homeDirPath() + "/Siag");
    if (!info.isDir())
        mkdir((const char*)info.absFilePath(), S_IRWXU);
    info.setFile(QDir::homeDirPath() + "/Siag/examples");
    if (!info.isDir()){
        mkdir((const char *)info.absFilePath(), S_IRWXU);
        KShellProcess cp;
        cp << "cp " << (const char *)(KApplication::kde_datadir()+
            "/ksiag/examples/* ") << "$HOME/Siag/examples";
        cp.start(KProcess::DontCare);
        QMessageBox::information(KSiagApp::manager()->activeTopLevel(),
                                 "KSiag Message",
                                 "Copied examples to $HOME/Siag/examples/.");
    }
    KConfig *config = KApplication::getKApplication()->getConfig();
    bool tutor = config->readBoolEntry("RunTutor", true);
    if (tutor){
        llpr("First use, running tutorial...");
        config->writeEntry("RunTutor", false);
        config->sync();
        KProcess proc;
        proc << "ksiagguru";
        if (!proc.start(KProcess::DontCare))
            llpr("Cannot start tutorial!");
    }
    KApplication::getKApplication()->exec();
}

int split_window (window *w)
{
    return(0); // No split windows yet, with tabs I'm not sure it makes sense.
}

window* new_window (buffer *b, window *prev)
{
    window *w;
    w = (window *)cmalloc(sizeof(window));
    if (!w)
        return (0);
    w->ui = (siag_ui *)cmalloc(sizeof(siag_ui));
    if (!w->ui){
        cfree(w);
        return (0);
    }
    w->buf = b;
    w->point_pos.row = w->point_pos.col = 1;
    w->blku.row = w->blku.col = 1;
    w->blkl.row = w->blkl.col = 1;
    w->buf->mark_pos.row = w->buf->mark_pos.col = 1;
    w->prot = w->top = w->point_pos;
    if (!prev)
        prev = w;
    else
        w->next = prev->next;
    prev->next = w;
    KSiagApp::manager()->addWindow(w);
    return(w);
}

void activate_window (window *w)
{
    KSiagApp::manager()->setActiveWindow(w);
}

int remove_window (window *w)
{
    if (w == w->next)
        return (0);
    KSiagApp::manager()->removeWindow(w);
    return(1);
}

void free_window (window *w)
{
    window *pw;

    for (pw = w_list; pw->next != w && pw->next != pw; pw = pw->next)
        ;
    pw->next = w->next;
    if (w_list == w)
        w_list = w_list->next;
    if (w_list == w)
        w_list = 0;
    cfree(w->ui);
    cfree(w);
}

void exit_windows ()
{
    while (b_list != NULL)
        free_buffer(b_list);
    while (w_list != NULL)
        free_window(w_list);
    KApplication::getKApplication()->quit();
}

buffer* create_empty_buffer()
{
    static char tmp[24];
    buffer *b;
    strcpy(tmp, buffer_name("noname.siag"));
    b = new_buffer(tmp, tmp);
    return(b);
}

int add_str_to_input_queue(textbuf buf)
{
    return(0);
}

int ask_for_str (char *prompt, char *buffer)
{
    int result;
    char *p;
    KSiagApp::manager()->activeTopLevel()->setLabelText(prompt);
    result = KSiagApp::manager()->activeTopLevel()->lineEdit()->exec(buffer);
    KSiagApp::manager()->activeTable()->setFocus();
    p = ret_text(w_list->buf, w_list->point_pos.row, w_list->point_pos.col);
    if (!p)
        p = "";
    draw_input(p);
    return(result);
}

int edit_cell (char *prompt, char *buffer)
{
    int x, y, result;
    int row = w_list->point_pos.row;
    int col = w_list->point_pos.col;
    KSiagTableManager *mgr = KSiagApp::manager();
    KSiagTable *tmp = mgr->activeTable();
    KSiagLineEdit *tbedit = mgr->activeTopLevel()->lineEdit();

    if (use_lineedit){
        use_lineedit = 0;
        tmp->setFocus();
        char *str = const_cast<char *>(tbedit->text());
        if (str){
            strcat(buffer, str+1);
            return (1);
        }
        else
            return(0);
    }
    KSiagCellEdit *edit = new KSiagCellEdit(tmp, tmp);
    tmp->rowYPos(w_list->point_pos.row-1, &y);
    tmp->colXPos(w_list->point_pos.col-1, &x);
    edit->move(x, y);
    edit->resize(tmp->cellWidth(col-1)-1, tmp->cellHeight(row-1)-1);
    edit->show();
    tbedit->connect(edit, SIGNAL(textChanged(const char *)), tbedit,
                    SLOT(setText(const char *)));
    mgr->activeTopLevel()->setLabelText(prompt);
    result = edit->exec(buffer);
    delete edit;
    tmp->setFocus();
    tbedit->setText(buffer);
    return(result);
}

int font_input (int *format, int *mask)
{
    return(0); 
}


void hide_cur (window *w)
{
}

void show_cur (window *w)
{
    char *p;

    if (pr_scr_flag){
	pr_scr();
    }
    else if (KSiagApp::manager()->activeWindow() == w){
        KSiagApp::manager()->activeTable()->setCursor();
        p = ret_text(w->buf, w->point_pos.row, w->point_pos.col);
        if (!p)
            p = "";
        draw_input(p);
        KSiagApp::manager()->activeTopLevel()->updateControls();

    }
}

void pr_scr()
{
    buffer *b;
    KSiagApp::manager()->activeTopLevel()->setStatusMessage(" ");
    b = b_list;
    do{
        if(b->recalc){
            int i;
            b->recalc = 0;
            for (i=0; i < recalc; i++)
                calc_matrix(b);
        }
        b = b->next;
    }while (b != b_list);
    KSiagApp::manager()->activeTopLevel()->updateControls();
    KSiagApp::manager()->activeView()->repaintAll();
    KSiagApp::manager()->activeTable()->setCursor();

    pr_scr_flag = FALSE;
}

void draw_input (char *text)
{
    long r, c;
    int type, intp, fmt;
    char b[1024];
    r = w_list->point_pos.row;
    c = w_list->point_pos.col;
    if (a1_refs)
        sprintf(b,"%s%ld", colnum_text(c), r);
    else
        sprintf(b, "[%ld,%ld]", r, c);
    KSiagApp::manager()->activeTopLevel()->setLabelText(b);
    type = ret_type(w_list->buf, r, c);
    intp = ret_interpreter(w_list->buf, r, c);
    switch (type){
    case EXPRESSION:
    case STRING:
        sprintf(b, "%s", interpreter2name(intp));
        break;
    case LABEL:
        strcpy(b, "LABEL");
        break;
    case EMPTY:
        strcpy(b, "EMPTY");
        break;
    default:
        strcpy(b, "ERROR");
    }
    fmt = ret_format(w_list->buf, r, c);
    KSiagApp::manager()->activeTopLevel()->setStatusType(b);
    KSiagApp::manager()->activeTopLevel()->lineEdit()->setText(text);
}

void paste_block()
{
    KSiagApp::clipBoard()->paste();
}

char* colnum_text(int col)
{
    static char b[80];
    if (a1_refs) {
        static char letters[] = " ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int i = 0, j = 0, c;
        while (col) {
            int digit = col % 26;
            if (!digit) digit = 26;
            b[i++] = letters[digit];
            col -= digit;
            col /= 26;
	}
        b[i--] = '\0';
        while (j < i) {
            c = b[i];
            b[i--] = b[j];
            b[j++] = c;
        }
    }
    else {
        sprintf(b, "%d", col);
    }
    return b;
}

// Lisp callbacks
static LISP bogus()
{
    warning("bogus called");
    return(NIL);
}

static LISP copy_block()
{
    KSiagApp::clipBoard()->copy();
    return(NIL);
}


static LISP get_geometry()
{
    unsigned int w, h, bw, depth;
    int x, y;
    LISP result;

    w = KSiagApp::manager()->activeTable()->width();
    h = KSiagApp::manager()->activeTable()->height();
    x = y = 0; // Who cares?
    bw = 1;
    depth = QPaintDevice::x11Depth();
    result = cons(flocons(depth), NULL);
    result = cons(flocons(bw), result);
    result = cons(flocons(h), result);
    result = cons(flocons(w), result);
    result = cons(flocons(y), result);
    result = cons(flocons(x), result);
    return(result);
}

static LISP add_menu_entry (LISP menu, LISP label, LISP function)
{
    if (!(KSiagApp::manager()->addMenuItem(get_c_string(menu), get_c_string(label),
                                           cstrdup(get_c_string(function)))))
        warning("KSiag: no menu %s, bailing out!", get_c_string(menu));
    return(NIL);
}

static LISP add_submenu (LISP label, LISP sublabel)
{
    if (!KSiagApp::manager()->addSubmenu(get_c_string(label), get_c_string(sublabel)))
        warning("KSiag: unable to add submenu %s->%s!", get_c_string(label),
                get_c_string(sublabel));
    return(NIL);

}

static LISP add_submenu_entry (LISP menu, LISP submenu, LISP label,
                               LISP function)
{
    if (!KSiagApp::manager()->addSubmenuEntry(get_c_string(menu), get_c_string(submenu),
                                  get_c_string(label), get_c_string(function)))
        warning("KSiag: unable to insert submenu item %s->%s->%s!",
                get_c_string(menu), get_c_string(submenu), get_c_string(label));
    return(NIL);
}

static LISP embed_unsupported (void)
{
    llpr("Embedding is not yet supported!");
    return(NIL);
}

static LISP fit_block_width()
{
    int r, c, font_index, text_width;
    char *p;

    if (block_upper(w_list).row < 1 || block_upper(w_list).col < 1 ||
        block_lower(w_list).row < 1 || block_lower(w_list).col < 1)
        return NIL;

    for (c = block_upper(w_list).col; c <= block_lower(w_list).col; c++) {
        set_width(buffer_of_window(w_list), c, 10);
        for (r = block_upper(w_list).row; r <= block_lower(w_list).row; r++) {
            font_index = ret_font(buffer_of_window(w_list), r, c);
            p = ret_pvalue(NULL, buffer_of_window(w_list), r, c, -1);
            text_width = ps_text_width(font_index, p);
            if (text_width > cell_width(buffer_of_window(w_list), c))
                set_width(buffer_of_window(w_list), c, text_width);
        }
    }
    pr_scr();
    return(NIL);
}

static LISP fit_block_height()
{
        int r, c, font_index, text_height;

        if (block_upper(w_list).row < 1 || block_upper(w_list).col < 1 ||
                block_lower(w_list).row < 1 || block_lower(w_list).col < 1)
                        return NIL;

        for (r = block_upper(w_list).row; r <= block_lower(w_list).row; r++) {
                set_height(buffer_of_window(w_list), r, 10);
                for (c = block_upper(w_list).col; c <= block_lower(w_list).col; c++) {
                        font_index = ret_font(buffer_of_window(w_list), r, c);
                        text_height = ps_font_height(font_index);
                        if (text_height > cell_height(buffer_of_window(w_list), r))
                                set_height(buffer_of_window(w_list), r, text_height);
                }
        }
        pr_scr();
        return(NIL);
}

static LISP set_block()
{
    if (get_point(w_list).row < get_mark(w_list).row) {
        set_blku_row(w_list, get_point(w_list).row);
        set_blkl_row(w_list, get_mark(w_list).row);
    } else {
        set_blku_row(w_list, get_mark(w_list).row);
        set_blkl_row(w_list, get_point(w_list).row);
    }
    if (get_point(w_list).col < get_mark(w_list).col) {
        set_blku_col(w_list, get_point(w_list).col);
        set_blkl_col(w_list, get_mark(w_list).col);
    } else {
        set_blku_col(w_list, get_mark(w_list).col);
        set_blkl_col(w_list, get_point(w_list).col);
    }
    KSiagApp::manager()->activeTable()->newBlock();

    pr_scr_flag = TRUE;
    return(NIL);
}

static LISP unset_block()
{
    set_blku_row(w_list, -1); set_blku_col(w_list, -1);
    set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
    pr_scr_flag = TRUE;
    KSiagApp::manager()->activeTable()->newBlock();
    return(NIL);
}

static LISP new_empty_buffer()
{
    set_window_buffer (w_list, create_empty_buffer());
    activate_window(w_list);
    return(NIL);
}

static LISP new_toplevel_window()
{
    activate_window(new_window(create_empty_buffer(), w_list));
    return(NIL);
}

static LISP kill_current_buffer()
{
    KSiagApp::manager()->removeBuffer(w_list->buf);
    return(NIL);
}

void embed_load()
{
    ;
}

// Siag dialogs
int select_file (char *path, char *name, char *patterns[], char *fmt)
{
    int i;
    KSiagFileDialog dlg(path, patterns, fmt);
    i = dlg.exec();
    QFileInfo info(dlg.selectedFile());
    if (i == QDialog::Rejected || info.isDir()){
        llpr("File op canceled");
        return (ABORT);
    }
    strcpy(name, (const char *)dlg.selectedFile());
    if (patterns)
        strcpy(fmt, patterns[dlg.getFilterIndex()]);
    path[0]='\0';
    return(DONE);
}

int alert_box (char *text, char *buttons[], int nbuttons)
{
    int result;
    KMsgBox *msg;
    
    // There is no insert button method, so we just switch to a max
    // of 4 buttons. Easier than making a new child...
    switch (nbuttons){
    case 1:
        msg = new KMsgBox(0, "Siag Alert!", text, KMsgBox::EXCLAMATION,
                          buttons[0]);
        break;
    case 2:
        msg = new KMsgBox(0, "Siag Alert!", text, KMsgBox::EXCLAMATION,
                          buttons[0], buttons[1]);
        break;
    case 3:
        msg = new KMsgBox(0, "Siag Alert!", text, KMsgBox::EXCLAMATION,
                          buttons[0], buttons[1], buttons[2]);
        break;
    case 4:
        msg = new KMsgBox(0, "Siag Alert!", text, KMsgBox::EXCLAMATION,
                          buttons[0], buttons[1], buttons[2], buttons[3]);
        break;
    default:
        if (nbuttons > 4)
            msg = new KMsgBox(0, "Siag Alert!", text, KMsgBox::EXCLAMATION,
                              buttons[0], buttons[1], buttons[2], buttons[3]);
        else // 0?
            return (0);
    }
    result = msg->exec();
    delete msg;
    return(result-1);
}

int select_from_list (char *text, char *choices[], int nchoices)
{
    KSiagList list(text, choices, nchoices);
    if (list.exec() == QDialog::Accepted){
        return(list.item());
    }
    return(ABORT);
}

void error_box (char *message)
{
    KMsgBox::message (0, "Siag Error!", message, KMsgBox::STOP);
}

void llpr (char *p)
{
    if (KSiagApp::log())
	KSiagApp::log()->insert(p);
    KSiagApp::manager()->activeTopLevel()->setStatusMessage(p);
}
