
#include "ksiag_app.h"
#include <stdio.h>
#include "../siod/siod.h"

static KSiagTableManager *mgr;
static KSiagPluginManager *pmgr;
static KSiagForm *frm;
static KSiagClipboard *clip;
static KSiagLogWindow *l;

KSiagApp::KSiagApp (int argc, char **argv)
    : KApplication (argc, argv)
{
    mgr = new KSiagTableManager;
    pmgr = new KSiagPluginManager;
    frm = new KSiagForm;
    clip = new KSiagClipboard;
    l = new KSiagLogWindow;
}


KSiagApp::~KSiagApp ()
{
    delete mgr;
    delete pmgr;
    delete frm;
    delete clip;
    if (l)
        delete l;
}

KSiagTableManager* KSiagApp::manager()
{
    return(mgr);
}

KSiagPluginManager* KSiagApp::pmanager()
{
    return(pmgr);
}

KSiagForm* KSiagApp::form()
{
    return(frm);
}

KSiagClipboard* KSiagApp::clipBoard()
{
    return(clip);
}

KSiagLogWindow* KSiagApp::log()
{
    return(l);
}
    
