/* -*- C++ -*- */
#ifndef __ACTION_H__
#define __ACTION_H__
//#include "Matrix.h"

class Action  {
public:
  Action(long, long, long, const char*, long m=0);
  virtual ~Action();

  long getSucc() const {return succ;}
  long getPred() const {return pred;}
  long getDur()  const {return dur;}
  const char *getText() const {return text;}
  
  void setSucc(long s) {succ=s;}
  void setPred(long p) {pred=p;}
  void setDur(long d) {dur=d;}
  int setText(const char*sz);
  
  long Get_lbt() const {return lbt;}
  long Get_let() const {return let;}
  long Get_eet() const {return eet;}
  long Get_ebt() const {return ebt;}

  void Set_lbt(long t) {lbt=t;}
  void Set_ebt(long t) {ebt=t;}
  void Set_eet(long t) {eet=t;}
  void Set_let(long t) {let=t;}

  char* print(char*, const char) ;
  void Mark()   {mark=1;}
  void UnMark() {mark=0;}
  
  int getIso() const {return iso;}
  void setIso(int i) {iso=i;}
  
  void setCrit(int c) {crit=c;}
  int  getCrit() const {return (let-eet>0) ? 0 : 1;}
  
  long get_tbt()  const {return lbt-ebt;}
  long get_ibt()  const {return ebt-let+dur;}
  long get_cabt() const {return get_tbt()-get_fbt();}
  long get_fbt()  const {return 0L;} /* not so important :-) */
  void reset() {lbt=0L; ebt=0L; eet=0L; let=0L; UnMark(); setCrit(0);};
  
private:
  long pred, succ;
  long dur;
  int mark, crit, iso;
  long lbt, ebt, let, eet;
  char *text;
};


#endif



