#include "TableDialog.h"
#include <qpushbt.h>


LabelInput::LabelInput(QWidget* parent, const char* name)
  : QDialog( parent, name, TRUE ){
    int mid = 100;
    int step = fontMetrics().height()+10;

    label = new QLabel("", this);
    label->setGeometry(10, 10, 180, step);

    edit = new QLineEdit(this);
    edit->setGeometry(10, 10 + step + 5, 180, step);

    int base = 10 + step + 5 + step + 5 + 10;

    QPushButton* ok, *cancel;
    ok = new QPushButton( "OK", this );
    ok->setDefault(TRUE);
    ok->setGeometry(mid-90, base, 80,step );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( mid, base, 80,step );
    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );      
}

const char* LabelInput::getString(const char* label_arg, const char* string_arg){
  label->setText(label_arg);
  edit->setText(string_arg);
  setCaption(name());
  edit->setFocus();
  if (exec())
    return edit->text();
  else
    return 0;
}
