/*
 * $Id: EditFigureDialog.h,v 1.2 1998/03/04 21:49:21 kalle Exp $
 */

#ifndef _EDITFIGUREDIALOG_H
#define _EDITFIGUREDIALOG_H

#include <qdialog.h>

class QCheckBox;
class QLineEdit;
class QPushButton;
class QRadioButton;

class LyXView;
class InsetFig;

class EditFigureDialog : public QDialog
{
friend class InsetFig;

  Q_OBJECT

public:
  EditFigureDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					 WFlags f=0 );

public:
  void setInsetFig( InsetFig* _inset ) { inset = _inset; }
  void disable();
  void enable();

private slots:
  void okClicked();
  void cancelClicked();
  void browseClicked();
  void applyClicked();
  void previewClicked();
  
  void returnPressed();

  void optionsGroupClicked( int );
  void heightGroupClicked( int );
  void widthGroupClicked( int );
  void displayGroupClicked( int );
  void subfigureToggled( bool );
  

private:
  LyXView* _view;
  InsetFig* inset;
  
  QLineEdit* epsfigureED;
  QPushButton* epsfigurePB;

  QRadioButton* wdefaultRB;
  QRadioButton* wcmRB;
  QRadioButton* winchesRB;
  QRadioButton* wpercentpageRB;
  QRadioButton* wpercentcolumnRB;
  QLineEdit* widthED;

  QRadioButton* hdefaultRB;
  QRadioButton* hcmRB;
  QRadioButton* hinchesRB;
  QRadioButton* hpercentpageRB;
  QLineEdit* heightED;

  QRadioButton* monochromeRB;
  QRadioButton* grayscaleRB;
  QRadioButton* colorRB;
  QRadioButton* dontdisplayRB;

  QCheckBox* frameCB;
  QCheckBox* translationsCB;

  QLineEdit* angleED;

  QCheckBox* subfigureCB;
  QLineEdit* captionED;

  QPushButton* okPB;
  QPushButton* applyPB;
  QPushButton* cancelPB;
  QPushButton* previewPB;
};

#endif

/*
 * $Log: EditFigureDialog.h,v $
 * Revision 1.2  1998/03/04 21:49:21  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/10 10:47:10  kalle
 * - added EditFigureDialog
 * version 0.1.5
 *
 */
