/*
 * $Id: BulletShapeDialog.h,v 1.2 1998/03/04 21:49:15 kalle Exp $
 */

#ifndef _BULLETSHAPEDIALOG_H
#define _BULLETSHAPEDIALOG_H

#include <qdialog.h>

class QComboBox;
class QLineEdit;
class QPushButton;
class QRadioButton;
class KIconLoader;

class LyXView;

class BulletShapeDialog : public QDialog
{
  Q_OBJECT

public:
  BulletShapeDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					  WFlags f=0 );
  ~BulletShapeDialog();

  void init();

private slots:
  void okClicked();
  void cancelClicked();
  void depthChanged( int );
  void groupChanged( int );
  void bulletSelected( int );
  void sizeChanged( int );
  void latexTextChanged( const char* );

private:
  LyXView* _view;
  
  QRadioButton* depth1RB;  
  QRadioButton* depth2RB;  
  QRadioButton* depth3RB;  
  QRadioButton* depth4RB;

  QPushButton* shapesPB[36];

  QComboBox* sizeCB;

  QLineEdit* latexED;

  QPushButton* okPB;
  QPushButton* cancelPB;

  bool pixmaps_loaded[6];
  QPixmap* pixmaps[6][36];

  KIconLoader* iconloader;

  int current_bullet_depth;
  int current_bullet_panel;
};


#endif

/*
 * $Log: BulletShapeDialog.h,v $
 * Revision 1.2  1998/03/04 21:49:15  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/03 23:41:52  kalle
 * BulletShapeDialog sort of works
 * It took me two Maribo Pilsner to get this far!
 * Still no images in BulletShapeDialog (will add these tomorrow)
 *
 * Revision 1.1  1998/01/09 19:51:12  kalle
 * Math matrix and math spacing dialogs added
 *
 */
