/* the Configuration Database library, Version II
 * copyright:  (C) Mirko Sucker, 1998 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */

#include <list>
#include "functions.h"

#include <qtextstream.h>

QString AuthorEmailAddress; // assign your email address to this string

QString ReadLineFromStream(QTextStream& stream)
{
  register bool GUARD; GUARD=false;
  // ############################################################################
  LG(GUARD, "ReadLineFromStream:: reading line.\n");
  QString line;
  // -----
  while(!stream.eof())
    {
      line=stream.readLine();
      if(!line.isEmpty())
	{
	  if(isComment(line))
	    {
	      line="";
	      continue;
	    }
	}
      break;
    }
  // -----
  LG(GUARD, "ReadLineFromStream:: line \"%s\" read.\n", line.data());
  return line;
  // ############################################################################
}

bool isComment(QString line)
{
  // ############################################################################
  line=line.stripWhiteSpace();
  if(line.isEmpty())
    {
      return false; // line is empty but not a comment
    } else  {
      return(line[0]=='#');
    }
  // ############################################################################
}

bool getHomeDirectory(QString& ref)
{
  register bool GUARD; GUARD=false;
  // ############################################################################
  char* temp=getenv("HOME");
  // -----
  if(temp!=0)
    {
      ref=temp;
      ref+="/";
      LG(GUARD, "getHomeDirectory: home is \"%s\".\n", ref.data());
      return true;
    } else {
      LG(GUARD, "getHomeDirectory: cannot find home of user"
	 " by searching environment var \"HOME\".\n");
      return false;
    }
  // ############################################################################
}

bool htmlizeString(const QString& orig, QString& target)
{
  register bool GUARD; GUARD=true;
  LG(GUARD, "htmlizeString: called.\n");
  // ############################################################################
  QString temp;
  char current;
  unsigned int index;
  // -----
  for(index=0; index<orig.length(); index++)
    { // ----- the following code is character set depending 
      //       and will possibly need recompilation for EVERY
      //       system using another charset than the machine
      //       it was compiled on! Lets see.
      current=orig[index];
      switch(current)
	{
	case '':
	default: temp+=current;
	}
    }
  target=temp;
  // -----
  LG(GUARD, "htmlizeString: done.\n");
  return false; // not implemented
  // ############################################################################
}

void tokenize(list<QString>& res, const QString& text, char tr, bool strict)
{
  register bool GUARD; GUARD=false;
  // ############################################################################
  LG(GUARD, "tokenize: called.\n");
  int eins=0, zwei=0;
  QString teil;
  // -----
  LG(GUARD, "tokenize: partening -->%s<--.\n", text.data());
  res.erase(res.begin(), res.end());
  // -----
  if(text.isEmpty())
    {
      LG(GUARD, "tokenize: test is an empty string, done.\n");
      return;
    }
  while(zwei!=-1)
    {
      teil="";
      zwei=text.find(tr, eins);
      if(zwei!=-1)
	{
	  teil=text.mid(eins, zwei-eins);
	  CHECK(teil.length()==(unsigned)zwei-eins);
	  res.push_back(teil);
	} else { // last element
	  if(!strict) // nur wenn dazwischen Zeichen sind
	    {
	      teil=text.mid(eins, text.length()-eins);
	      CHECK(teil.length()==text.length()-eins);
	      res.push_back(teil);
	    }
	}
      eins=zwei+1;
      // if((unsigned)eins>=text.length()) break;
    }
  LG(GUARD, "tokenize: partened in %i parts.\n", res.size());
  // -----
  LG(GUARD, "tokenize: done.\n");
  // ############################################################################
}



