/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "serverpropdlg.h"
#include "dlgloader/kdlgldr.h"
#include <krestrictedline.h>
#include <ksimpleconfig.h>
#include <kmsgbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qdialog.h>
#include <qpushbt.h>

ServerPropDlg::ServerPropDlg(const char *profile)
        :QObject(0)
{
    QString cpath=(KApplication::localkdedir()+"/share/apps/newkrn/servers/")+profile;
    KSimpleConfig conf(cpath);
    conf.setGroup("ServerOptions");

    QDialog *d=new QDialog(0,0,true);
    QString path=(KApplication::kde_datadir()+"/newkrn/dialogs/serverprop.kdevdlg");
    KDlgLoader *l=new KDlgLoader(d);
    l->openDialog(path);

    profname=(QLineEdit *)(l->getItemPtrVarName("profname"));
    profname->setText(profile);
    profname->setEnabled(false);

    servname=(QLineEdit *)(l->getItemPtrVarName("servname"));
    servname->setText(conf.readEntry("name"));

    portnumber=(KRestrictedLine *)(l->getItemPtrVarName("portnumber"));
    portnumber->setValidChars("0123456789");
    portnumber->setText(conf.readEntry("port","119"));

    auth=(QCheckBox *)(l->getItemPtrVarName("auth"));
    auth->setChecked(conf.readNumEntry("auth",false));
    QObject::connect(auth,SIGNAL(clicked()),this,SLOT(authChanged()));

    username=(QLineEdit *)(l->getItemPtrVarName("username"));
    username->setText(conf.readEntry("username",""));

    password=(QLineEdit *)(l->getItemPtrVarName("password"));
    password->setText(conf.readEntry("password",""));
    password->setEchoMode (QLineEdit::Password);

    authChanged();

    QPushButton *ok=(QPushButton *)(l->getItemPtrVarName("ok"));
    ok->setDefault(true);
    QPushButton *cancel=(QPushButton *)(l->getItemPtrVarName("cancel"));
    QPushButton *test=(QPushButton *)(l->getItemPtrVarName("test"));
    QObject::connect(ok,SIGNAL(clicked()),d,SLOT(accept()));
    QObject::connect(cancel,SIGNAL(clicked()),d,SLOT(reject()));

    while (1)
    {
        int res=d->exec();
        if (!res)
            return;
        QString profilename=profname->text();
        QString servername=servname->text();
        if (servername.isEmpty())
        {
            KMsgBox::message(0,"Error","You must enter a server name",0,"OK");
            continue;
        }
        QString port=portnumber->text();
        if (port.isEmpty())
        {
            KMsgBox::message(0,"Error","You must enter a port number",0,"OK");
            continue;
        }
        conf.writeEntry("name",servername);
        conf.writeEntry("port",port);
        conf.writeEntry("auth",auth->isChecked());
        if (auth->isChecked())
        {
            conf.writeEntry("username",username->text());
            conf.writeEntry("password",password->text());
        }
        else
        {
            conf.deleteEntry("username",false);
            conf.deleteEntry("password",false);
        }
        conf.sync();
        break;
    }
    delete l;
    delete d;
}
ServerPropDlg::~ServerPropDlg()
{
}

void ServerPropDlg::authChanged()
{
    username->setEnabled(auth->isChecked());
    password->setEnabled(auth->isChecked());
}




