/***************************************************************************
                          newkrn.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun  8 20:40:39 /etc/localtime 1999
                                           
    copyright            : (C) 1999 by Roberto Alsina                         
    email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <mimelib/mimepp.h>
#include <pth.h>

#include <newkrn.h>

#include "kmtapplication.h"
#include "util.h"

NewKrnApp::NewKrnApp()
{
    setCaption("NewKrn " VERSION);

    ///////////////////////////////////////////////////////////////////
    // read the config file options
    readOptions();

    ///////////////////////////////////////////////////////////////////
    // call inits to invoke all other construction parts
    initMenuBar();
    initToolBar();
    initStatusBar();
    initView();

    ///////////////////////////////////////////////////////////////////
    // enable bars dependend on config file setups
    if (!bViewToolbar)
        enableToolBar(KToolBar::Hide,0);
    if (!bViewStatusbar)
        enableStatusBar(KStatusBar::Hide);

    menuBar()->setMenuBarPos(menu_bar_pos);
    toolBar()->setBarPos(tool_bar_pos);

    ///////////////////////////////////////////////////////////////////
    // disable menu and toolbar items at startup

}

NewKrnApp::~NewKrnApp()
{

}

void NewKrnApp::enableCommand(int id_)
{
    ///////////////////////////////////////////////////////////////////
    // enable menu and toolbar functions by their ID's
    menuBar()->setItemEnabled(id_,true);
    toolBar()->setItemEnabled(id_,true);
}

void NewKrnApp::disableCommand(int id_)
{
    ///////////////////////////////////////////////////////////////////
    // disable menu and toolbar functions by their ID's
    menuBar()->setItemEnabled(id_,false);
    toolBar()->setItemEnabled(id_,false);
}


void NewKrnApp::initMenuBar()
{

    ///////////////////////////////////////////////////////////////////
    // MENUBAR

    ///////////////////////////////////////////////////////////////////
    // menuBar entry file_menu
    file_menu = new QPopupMenu();
    file_menu->insertItem(Icon("mini/newkrnapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
    file_menu->insertSeparator();
    file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
    file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
    file_menu->insertSeparator();
    file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
    file_menu->insertItem(i18n("Save &as"), ID_FILE_SAVE_AS );
    file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
    file_menu->insertSeparator();
    file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
    file_menu->insertSeparator();
    file_menu->insertItem(i18n("C&lose Widow"), ID_FILE_CLOSE_WINDOW);
    file_menu->insertSeparator();
    file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

    // file_menu key accelerators
    file_menu->setAccel(CTRL+Key_N, ID_FILE_NEW);
    file_menu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
    file_menu->setAccel(CTRL+Key_S, ID_FILE_SAVE);
    file_menu->setAccel(CTRL+Key_W, ID_FILE_CLOSE);
    file_menu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
    file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


    ///////////////////////////////////////////////////////////////////
    // menuBar entry edit_menu
    edit_menu = new QPopupMenu();
    edit_menu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT );
    edit_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
    edit_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );

    //edit_menu key accelerators
    edit_menu->setAccel(CTRL+Key_X, ID_EDIT_CUT);
    edit_menu->setAccel(CTRL+Key_C, ID_EDIT_COPY);
    edit_menu->setAccel(CTRL+Key_V, ID_EDIT_PASTE);


    ///////////////////////////////////////////////////////////////////
    // menuBar entry view_menu
    view_menu = new QPopupMenu();
    view_menu->setCheckable(true);
    view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
    view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

    view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
    view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

    ///////////////////////////////////////////////////////////////////
    // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


    ///////////////////////////////////////////////////////////////////
    // menuBar entry help_menu
    help_menu = new QPopupMenu();
    help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


    ///////////////////////////////////////////////////////////////////
    // MENUBAR CONFIGURATION
    // set menuBar() the current menuBar and the position due to config file
    menuBar()->insertItem(i18n("&File"), file_menu);
    menuBar()->insertItem(i18n("&Edit"), edit_menu);
    menuBar()->insertItem(i18n("&View"), view_menu);

    ///////////////////////////////////////////////////////////////////
    // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


    menuBar()->insertSeparator();
    menuBar()->insertItem(i18n("&Help"), help_menu);

    ///////////////////////////////////////////////////////////////////
    // CONNECT THE SUBMENU SLOTS WITH SIGNALS

    CONNECT_CMD(file_menu);
    CONNECT_CMD(edit_menu);
    CONNECT_CMD(view_menu);

}
void NewKrnApp::initToolBar()
{

    ///////////////////////////////////////////////////////////////////
    // TOOLBAR
    // set toolBar() the current toolBar and the position due to config file
    toolBar()->insertButton(Icon("disconnected.xpm"), ID_ONLINE, true, i18n("On/Offline"));
    toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File"));
    toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
    toolBar()->insertSeparator();
    toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut"));
    toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy"));
    toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste"));
    toolBar()->insertSeparator();
    toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

    ///////////////////////////////////////////////////////////////////
    // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
    // add functionality for new created toolbars in:
    // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
    // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
    // Also update resource values and commands


    ///////////////////////////////////////////////////////////////////
    // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
    CONNECT_TOOLBAR(toolBar());

}

void NewKrnApp::initStatusBar()
{
    ///////////////////////////////////////////////////////////////////
    //STATUSBAR
    statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
    statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void NewKrnApp::initView()
{
    doc = new NewKrnDoc(this);

    ////////////////////////////////////////////////////////////////////
    // set the main widget here
    KApplication *app=KApplication::getKApplication();
    view = new NewKrnView(app,doc,this);
    setView(view);
}

bool NewKrnApp::queryExit()
{
    debug ("queryexit");
    int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));

    if(exit==1)
        return true;
    else
        return false;
}

void NewKrnApp::saveOptions()
{
    KConfig *config = kapp->getConfig();


    config->setGroup("APPEARANCE");
    config->writeEntry("ShowToolbar",toolBar()->isVisible());
    config->writeEntry("ShowStatusbar",statusBar()->isVisible());
    config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
    config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

}

void NewKrnApp::readOptions()
{
    ///////////////////////////////////////////////////////////////////
    // read the config file entries
    KConfig *config = kapp->getConfig();


    config->setGroup("APPEARANCE");
    bViewToolbar = config->readBoolEntry("ShowToolbar", true);
    bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
    menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);
    tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void NewKrnApp::slotFileNewWindow()
{
    slotStatusMsg(i18n("Opening a new Application window..."));
    (new NewKrnApp)->show();
    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotFileNew()
{
    slotStatusMsg(i18n("Creating new file..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotFileOpen()
{
    slotStatusMsg(i18n("Opening file..."));

    slotStatusMsg(IDS_DEFAULT);
}


void NewKrnApp::slotFileSave()
{
    slotStatusMsg(i18n("Saving file..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotFileSaveAs()
{
    slotStatusMsg(i18n("Saving file under new filename..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotFileClose()
{
    slotStatusMsg(i18n("Closing file..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotFilePrint()
{
    slotStatusMsg(i18n("Printing..."));

    QPrinter printer;
    if (printer.setup(this))
    {
        QPainter painter;
        painter.begin( &printer );

        ///////////////////////////////////////////////////////////////////
        // TODO: Define printing by using the QPainter methods here

        painter.end();
    };

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotFileCloseWindow()
{
    close();
}
void NewKrnApp::slotFileQuit()
{
    ///////////////////////////////////////////////////////////////////
    // exits the Application
    if(this->queryExit())
    {
        saveOptions();
        KTMainWindow::deleteAll();
        KMTApplication::quit();
    }
    else
    {
        slotStatusMsg(IDS_DEFAULT);
    }
    return;
}

void NewKrnApp::slotEditCut()
{
    slotStatusMsg(i18n("Cutting selection..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotEditCopy()
{
    slotStatusMsg(i18n("Copying selection to Clipboard..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotEditPaste()
{
    slotStatusMsg(i18n("Inserting Clipboard contents..."));

    slotStatusMsg(IDS_DEFAULT);
}

void NewKrnApp::slotViewToolBar()
{
    ///////////////////////////////////////////////////////////////////
    // turn Toolbar on or off
    bViewToolbar=!bViewToolbar;
    menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
    enableToolBar(KToolBar::Toggle,0);
    slotStatusMsg(IDS_DEFAULT);

}

void NewKrnApp::slotViewStatusBar()
{
    ///////////////////////////////////////////////////////////////////
    //turn Statusbar on or off
    bViewStatusbar=!bViewStatusbar;
    menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
    enableStatusBar();
    slotStatusMsg(IDS_DEFAULT);
}


void NewKrnApp::slotStatusMsg(const char *text)
{
    ///////////////////////////////////////////////////////////////////
    // change status message permanently
    statusBar()->clear();
    statusBar()->changeItem(text, ID_STATUS_MSG );
}


void NewKrnApp::slotStatusHelpMsg(const char *text)
{
    ///////////////////////////////////////////////////////////////////
    // change status message of whole statusbar temporary (text, msec)
    statusBar()->message(text, 2000);
}



void NewKrnApp::commandCallback(int id_)
{
    switch (id_)
    {
        ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
        ON_CMD(ID_FILE_NEW,                 slotFileNew())
        ON_CMD(ID_FILE_OPEN,                slotFileOpen())
        ON_CMD(ID_FILE_SAVE,                slotFileSave())
        ON_CMD(ID_FILE_SAVE_AS,             slotFileSaveAs())
        ON_CMD(ID_FILE_CLOSE,               slotFileClose())
        ON_CMD(ID_FILE_PRINT,               slotFilePrint())
        ON_CMD(ID_FILE_CLOSE_WINDOW,        slotFileCloseWindow())
        ON_CMD(ID_FILE_QUIT,                slotFileQuit())

        ON_CMD(ID_EDIT_CUT,                 slotEditCut())
        ON_CMD(ID_EDIT_COPY,                slotEditCopy())
        ON_CMD(ID_EDIT_PASTE,               slotEditPaste())

        ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
        ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
    }
}

void NewKrnApp::statusCallback(int id_)
{
    switch (id_)
    {
        ON_STATUS_MSG(ID_FILE_NEW_WINDOW,   i18n("Opens a new application window"))
        ON_STATUS_MSG(ID_FILE_NEW,          i18n("Creates a new document"))
        ON_STATUS_MSG(ID_FILE_OPEN,         i18n("Opens an existing document"))
        ON_STATUS_MSG(ID_FILE_SAVE,         i18n("Save the actual document"))
        ON_STATUS_MSG(ID_FILE_SAVE_AS,      i18n("Save the document as..."))
        ON_STATUS_MSG(ID_FILE_CLOSE,        i18n("Closes the actual file"))
        ON_STATUS_MSG(ID_FILE_PRINT,        i18n("Prints the current document"))
        ON_STATUS_MSG(ID_FILE_CLOSE_WINDOW, i18n("Closes the current window"))
        ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))

        ON_STATUS_MSG(ID_EDIT_CUT,          i18n("Cuts the selected section and puts it to the clipboard"))
        ON_STATUS_MSG(ID_EDIT_COPY,         i18n("Copys the selected section to the clipboard"))
        ON_STATUS_MSG(ID_EDIT_PASTE,        i18n("Pastes the clipboard contents to actual position"))
        ON_STATUS_MSG(ID_EDIT_SELECT_ALL,   i18n("Selects the whole document contents"))


        ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the actual Toolbar"))
        ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))
    }
}
