/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* web.h */

#ifndef WEB_H
#define WEB_H

#include	<sys/types.h>	/* basic system data types */
#include	<sys/socket.h>	/* basic socket definitions */
#include	<sys/time.h>	/* timeval{} for select() */
#include	<netinet/in.h>	/* sockaddr_in{} and other Internet defns */
#include	<arpa/inet.h>	/* inet(3) functions */
#include	<errno.h>
#include	<fcntl.h>		/* for nonblocking */
#include	<netdb.h>
#include	<sys/stat.h>	/* for S_xxx file mode constants */
#include	<sys/uio.h>		/* for iovec{} and readv/writev */
#include	<unistd.h>
#include	<sys/wait.h>
#include	<sys/un.h>		/* for Unix domain sockets */

ssize_t writen(int, const void *, size_t);
int	 tcp_connect(const char *, const char *);

char	*gai_strerror(int);
#define MAXLINE 1024
#define MAX_HEADER 512
#define	SERV		"80"	/* port number or service name */

#define	GET_CMD	 "GET %s HTTP/1.0\r\nHost: %s\r\nIf-Modified-Since: %s\r\n\r\n"
#define GET_CMD_PROX  "GET http://%s HTTP/1.0\r\nHost: %s\r\nIf-Modified-Since: %s\r\n\r\n"


/*#define GET_CMD "GET %s HTTP/1.0\r\nIf-Modified-Since: %s\r\n\r\n"
#define GET_CMD_PROX "GET http://%s HTTP/1.0\r\nIf-Modified-Since: %s\r\n\r\n"
*/



#endif //WEB_H
