/* 	This file is part of the KDE libraries

		kpwdbox.cpp - Dialog to check a password, written by Sam Watt
		
    Copyright (C) 1999 Corel Corporation
  		 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "kpwdbox.h"
#include <kapp.h>
#include <kprocess.h>

#define MAX_PASSWORD_LENGTH 100

KPwdBox::KPwdBox(QWidget *par, const char *name, bool modal, WFlags f) 
: QDialog(par, name, modal, f)
{
	m_pParent = par;

	msg = new QLabel("",this,"message");
	msg->resize(msg->sizeHint());

	pwdBox = new KPasswordEdit(this,"pwdbox");
	pwdBox->resize(pwdBox->sizeHint());

        ok = new QPushButton("OK",this);
	ok->resize(ok->sizeHint());
	connect(ok, SIGNAL(clicked()), this, SLOT(accept()));

	cancel = new QPushButton("Cancel", this);
	cancel->resize(cancel->sizeHint());
	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
	
	pwdBox->setFocus();
	ok->setDefault(true);

	setFixedSize(sizeHint());
	setLocalGeometry();
}

void KPwdBox::setMessage(const char *label)
{
	msg->setText(label);
	msg->resize(msg->sizeHint());
	setFixedSize(sizeHint());
	setLocalGeometry();
}

void KPwdBox::resize(QSize size)	{ resize( size.width(), size.height() ); }

void KPwdBox::resize(int width, int height)
{
	QSize temp(sizeHint());
	if (width != temp.width() || height != temp.height()) resize(temp);

	int offsetX1 = 10;
	int offsetX2 = width - 10 - cancel->width();

	int offsetY1 = 10;
	int offsetY2 = offsetY1 + msg->height() + 10;
	int offsetY3 = offsetY2 + pwdBox->height() + 10;

	msg->setGeometry(offsetX1, offsetY1, msg->width(), msg->height());
	pwdBox->setGeometry(offsetX1, offsetY2, width - 20, pwdBox->height());
	ok->setGeometry(offsetX1, offsetY3, ok->width(), ok->height());
	cancel->setGeometry(offsetX2, offsetY3, cancel->width(), cancel->height());
}

void KPwdBox::setLocalGeometry()
{
	int x;
	int y;
	
	x = pos().x();
	y = pos().y();

	if( m_pParent )
	{
		x = ( m_pParent->width() - sizeHint().width() ) / 2 + m_pParent->x();
		y = ( m_pParent->height() - sizeHint().height() ) / 2 + m_pParent->y();
	}
	
	setGeometry( x, y, sizeHint().width(), sizeHint().height() );	
}

QSize KPwdBox::sizeHint()
{
	QSize temp;
	QSize result(250,20);

	temp = msg->sizeHint();
	if (temp.width() > result.width()) result.setWidth( temp.width() + 20 );
	result.setHeight( result.height() + temp.height() );

	temp = pwdBox->sizeHint();
	result.setHeight( 10 + result.height() + temp.height() );

	temp = ok->sizeHint();
	result.setHeight( 10 + result.height() + temp.height() );

	return result;
}

int KPwdBox::exec()
{
	int nRet = -1;
	if (QDialog::exec())
	{
	  QString password = pwdBox->text();
	  KProcess chkpass;
	  QString kcp_binName = "";
	  kcp_binName += KApplication::kde_bindir();
	  kcp_binName += "/kcheckpass";
	  chkpass.clearArguments();
	  chkpass << kcp_binName;
	  chkpass << "-s";		
	  nRet = chkpass.start(KProcess::DontCare, KProcess::Stdin);
	  if (nRet)
	  {
	    chkpass.writeStdin( password.data(), password.length()); // write Password to stdin
	    chkpass.closeStdin();                // eof

	    int timeout = 10;
	    while ( timeout != 0 ) 
            {
	      if (! chkpass.isRunning() )
	        break;
	      else 
	      {
	        KApplication::getKApplication()->processEvents();
	        timeout--;
	        sleep(1);
	      }
	    }
	    nRet = ( chkpass.normalExit() && (chkpass.exitStatus() == 0));
	  }
	}
	return nRet; 
}

KPasswordEdit::KPasswordEdit ( QWidget * parent, const char * name)
	:QLineEdit(parent, name)
{
	setEchoMode(Password);
	setMaxLength(MAX_PASSWORD_LENGTH);
}

void KPasswordEdit::focusOutEvent(QFocusEvent *e)
{
  deselect();
  QLineEdit::focusOutEvent(e);
}

