/* ------------------------------------------------------------- 

    kngnntp.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: kngnntp.cpp,v 1.7 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */


#include <kngnntp.h>
#include <view.h>

NNTP::NNTP( )
  :DwNntpClient()
{
  s_mode = false;

  config = kapp->getConfig();
  readConfig();
  
  SetReceiveTimeout( 300 );

  debug( "Opening connection to server %s on port %d",  ( const char * ) servername, port );

  if ( ! Open( servername, port ) )
    QMessageBox::warning( 0,"K News Grabber", LastErrorStr() );
  
  hash = new KNGHash( s_mode );
  homepath = QDir::homeDirPath();
  homepath.append( "/" );

} 

NNTP::NNTP(QString configfile, bool sm )
  :DwNntpClient()
{
  s_mode = sm;

  if ( s_mode )
    config = new KConfig( 0, ( const char * ) configfile );
  else
    {
      debug ( "Getting kconfig from kapp" );
      config = kapp->getConfig();
    }
  
  readConfig();
  
  debug( "Opening connection to server %s on port %d",  ( const char * ) servername, port );

  if ( ! Open( servername, port ) )
    {
      if ( s_mode )
	debug( "Server returned %s", LastErrorStr() );
      else
	QMessageBox::warning( 0,"K News Grabber", LastErrorStr() );
    }
  hash = new KNGHash( sm );
  homepath = QDir::homeDirPath();
}


NNTP::~NNTP()
{
  hash->writeData();
}

const char *
NNTP::initGroup( const char *grpname )
{
  QString string = grpname;

  if ( ! IsOpen() )
    ReOpen("");

  if ( IsOpen() )
    {
      debug( "Connection Open" );
      if ( Group( grpname ) != 211 )
	{
	  // Perhaps I have to send the Command mode reader
	  DwString str = "mode reader";
	  SendData( str );

	  if ( ReplyCode() == 200 )
	    {
	      // This is an innd which forks nnrp
	      if ( Group( grpname ) == 211 )
		{
		  char *efld;
		  char *tmp = strdup( StatusResponse().data() );

		  
		  // First Call ->contains 211
		  efld = strtok( tmp, " " );
		  // Second Call -> Should return estimated number of articles in group
		  efld = strtok( NULL, " " );
		  
		  string.append( "| ");
		  string.append( efld );
		  string.append( " |{G}Active" );
		  //free ( tmp );
		  delete tmp;
		  return strdup( string );
		}
	    }

	  string.append( "| ???|{R}Unknown" );
	  return strdup( string );
	}
      else if ( ReplyCode() == 211 )
	{
	  debug( "ReplyCode is 211" );
	  char *efld;
	  char *tmp = strdup( StatusResponse().data() );
	  
	  // First Call ->contains 211
	  efld = strtok( tmp, " " );
	  // Second Call -> Should return estimated number of articles in group
	  efld = strtok( NULL, " " );
	  
	  string.append( "| ");
	  string.append( efld );
	  string.append( " |{G}Active" );
	  //free ( tmp );
	  delete tmp;
	  return strdup( string );
	}
    }
  debug ( "Connection not open. ReOpen Failed" );
  string.append( "| ??? |{R}Failure" );
  return strdup( string );
}

void
NNTP::readConfig()
{

  struct tm *bt;
  time_t timep;
  
  timep = time( NULL );
  bt = localtime( &timep );
  QString str;

  config->setGroup( "Settings" );

  if ( config->hasKey( "nntpserver" ) )
    {
      servername = config->readEntry( "nntpserver", "news" );
    }
  else
    {
      servername = getenv( "NNTPSERVER" );
    }

  port = config->readNumEntry( "nntpport", 119 );
  debug ( "path is %s", ( const char  * ) config->readEntry( "path", "no path") );

  str.sprintf( "%.2d%.2d%.2d", bt->tm_year, bt->tm_mon, bt->tm_mday );
  ladate = config->readEntry( "ladate", str );

  str.sprintf( "%.2d%.2d%.2d", bt->tm_hour, bt->tm_min, bt->tm_sec );
  latime = config->readEntry( "latime", str );
}


void 
NNTP::writeConfig()
{

  struct tm *bt;
  time_t timep;

  timep = time( NULL );
  bt = localtime( &timep );

  ladate.sprintf( "%.2d%.2d%.2d", bt->tm_year, bt->tm_mon, bt->tm_mday );
  latime.sprintf( "%.2d%.2d%.2d", bt->tm_hour, bt->tm_min, bt->tm_sec );


  // It must be a flag here indicating processing of groups
  
  if ( config )
    debug ( "Config exists ! " );
  else
    debug ( "Config didnt ! " );

  config->setGroup( "Settings" );
  config->writeEntry( "ladate", ladate );
  config->writeEntry( "latime", latime );
  //  free ( bt );
  
  hash->writeData();
}

int
NNTP::procGroups( QStrList strlist, QWidget *widget )
{
  QString str;
  for( str = strlist.first(); str != 0; str = strlist.next() ) 
    procGroup( str, widget ); 
  
  return 1; 
}

int
NNTP::ReOpen( QString grpname)
{
  Close();

  Open( servername, 119 );
  
  if ( ! grpname.isEmpty() ) 
    Group( grpname);
  return 1;
}

int
NNTP::procGroup( const char *grpname, QWidget *widget )
{
  int status;

  KNGHashEntry *hentry;


  if ( ! IsOpen() )
    {
      ReOpen( grpname);
      return 1;
    }

  if ( ( status = Group( grpname ) ) == 211 )
    {
      char *begptr;
      int begin, end, artcounter = 0,  counter = 0;
      
      char *tmp = strdup( mStatusResponse.data() );

      begptr = strtok( tmp,  " " );
      begptr = strtok( NULL, " " );
      begptr = strtok( NULL, " " );

      begin = atoi( begptr );
      begptr = strtok( NULL, " " );
      end = atoi( begptr );
      

      if ( ! s_mode )
	{
	  pdialog = new QProgressDialog( i18n( "Processing newsgroup" ),
					 "Cancel", end - begin + 1, widget );
	  pdialog->setProgress( 0 );
	  kapp->processEvents();
	}

      DwString str = "body\n";
      
      artcounter = begin;
      delete tmp;
      
      status = Stat( begin );
      char *msgid;
      

      do {
	msgid = NULL;
	if ( !s_mode && ! pdialog->isVisible() )
	  pdialog->show();

	tmp = strdup( mStatusResponse.data() );
	msgid = strtok( tmp, " " );
	msgid = strtok( NULL, " " );
	msgid = strtok( NULL, " " );

	if ( ! msgid )
	  {
	    debug( "StatusResonse is %s", mStatusResponse.data() );
	    debug( "LastError is %d", LastError() );
	    debug( "LastErrorString is %s", LastErrorStr() );
	    debug( "Status of ServerResponse %d", ReplyCode() );
	    debug( "This server does not implement RFC 977 properly" );
	    if ( ! s_mode )
	      delete pdialog;
	    return 1;
	  }

	if ( ! s_mode ) 
	  kapp->processEvents();

	if ( hash->find( msgid ) )
	  {
	    debug ( "key found skipping" );
	    delete tmp;
	    if ( ! s_mode )
	      {
		pdialog->setProgress( ++counter );
		if ( pdialog->wasCancelled() )
		  break;
	      }
	    continue;
	  }
	
	hentry = new KNGHashEntry( strdup (msgid) );
	hash->insert( msgid, hentry );
	debug ( "key is new " );
	delete tmp;

	status = Body( );
	
	if ( ! s_mode )
	  {
	    kapp->processEvents();
	    if ( pdialog->wasCancelled() )
	      break;
	  }
	Endec();

	if ( ! s_mode )
	  {
	    kapp->processEvents();
	    pdialog->setProgress( ++counter);
	  }

      } while ( ( status = Next() ) < 400 && status != 0 );
      
      debug( "LastErrorCode is %d", LastError() );
      if ( ! s_mode )
	{
	  pdialog->setProgress( end - begin + 1 );
	  pdialog->hide();

	  if ( status != 421 && ( ! pdialog->wasCancelled() ) )
	    {
	      QString a = ( i18n( "News Server returned following\nduring processing of group\n" ) );
	      a.append( grpname );
	      a.append( "\n" );
	      a.append( LastErrorStr() );
	      QMessageBox::information( widget , "K News Grabber", ( const char *) a );
	    }
	  delete pdialog;
	}
    }
  return 1;
}

void
NNTP::Endec()
{

  QString str;
  QFileInfo fi;

  endec = new DwUuencode();
  endec->SetAsciiChars( mTextResponse );

  // Begin decode

  if ( endec->Decode() == 0 )
    {
      config->setGroup( "Settings" );
      QString fname = config->readEntry( "path", homepath ); 
      str = endec->FileName();
      
      fname.append( str.lower() );
      DwString bin = endec->BinaryChars();
      
      QFile f( fname );
      if ( ! f.exists() )
	// file does not exist
	{
	  if ( ! f.open( IO_WriteOnly ) )
	    debug( "Could not open file %s", f.name() );
	  else 
	    {
	      f.writeBlock( bin.data(), bin.length() );
	      f.close();
	      if ( ! s_mode )
		( ( View *) MView )->insertImg( bin, fname );
	    }
	}  
      else 
	{
	  debug( "File exists" );
	  // file exists
	  fi.setFile( f );
	  if ( fi.size() != bin.length() )
	    {
	      // sizes are not equal
	      debug( "Sizes are not equal" );
	      QString lstr;
	      int ctr = 1;
	      do {
		lstr.sprintf("%s(%d).%s", ( const char *) fi.baseName(),
			     ctr, ( const char * ) fi.extension() );
		lstr.prepend ( config->readEntry( "path", homepath ) );
		ctr++;
	      } while ( QFile::exists( lstr ) );
	      
	      debug ("Filename %s doesnt exist", (const char *) lstr );
	      f.setName( lstr );
	      
	      if ( ! f.open( IO_WriteOnly ) )
		debug( "Could not open file %s", f.name() );
	      else
		{
		  f.writeBlock( bin.data(), bin.length() );
		  f.close();
		}
	    }
	  else 
	    {
	      // sizes are equal user should decide what to do.
	      debug( "Sizes are equal. User should decide" );
	    }
	}
    }
  delete endec;
}

void
NNTP::deletehash()
{
  hash->deletehashFile();
}

