/* ------------------------------------------------------------- 

    main.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: main.cpp,v 1.8 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */

#include <kapp.h> 
#include <kngnntp.h>
#include <ktopwidget.h>
#include <toplevel.h>
#include <kconfig.h>
#include <qstring.h>
#include <qfile.h>
#include <kngoptiondialog.h>
#include <kimgio.h>

NNTP *Connect;

void
Init()
{
  KConfig *config = kapp->getConfig();
  kimgioRegister();
  
  config->setGroup( "Settings" );
  if( ! config->hasKey( "nntpserver" ) ) {
    KNGOptionDialog *odtmp = new KNGOptionDialog( 0 );
    odtmp->exec();
    delete odtmp;
  }
  // Last Call 
  Connect = new NNTP();
}


int main(int argc, char *argv[])
{

  int s_mode = 0;
  QStrList * s_grps = 0;
  QString configfile;
  
  for ( int i = 0; i < argc; i++ )
    {
      debug( "argc%d is %s", i , argv[i] );

      // dangerous, will be fixed later;
      // fixme
      if ( strcmp( argv[ i ], "-j" ) == 0 || s_mode )
	{
	  s_mode = 1;
	  if ( ! s_grps )
	    s_grps = new QStrList();
	  else 
	    s_grps->append( argv[ i ] );
	}
      if ( strcmp( argv[ i ], "-c" ) == 0 )
	configfile = argv[ i + 1 ];
    }

  if ( s_mode )
    {
      Connect = new NNTP( configfile, s_mode );
      Connect->procGroups( *s_grps, 0 );
      Connect->writeConfig();
      return 0;
    }
  else
    {
      KIconLoader *ldr;
      KApplication app( argc, argv, "kng" );
      Init();
      
      ldr = app.getIconLoader();
      ldr->insertDirectory( 1, "/home/ctuztas/work/kng/pics" );
      
      TopLevel *toplevel=0;
      
      if (app.isRestored())
	RESTORE(TopLevel)
	  else {
	    // no session management: just create one window
	    toplevel = new TopLevel();
	    toplevel->show();
	  }
      toplevel->show();
      
      return app.exec();
    }
}

