/***************************************************************************
                          knetstartview.h  -  A simple netconfig tool
                             -------------------
    begin                : Thu Sep 30 20:48:28 CDT 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNETSTARTVIEW_H
#define KNETSTARTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>

class KnetstartDoc;
class QLineEdit;
class QPushButton;
class QCheckBox;
class IPinput;
class netmap;

/** The KnetstartView class provides the view widget for the KnetstartApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KnetstartView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the KnetstartApp class to manipulate and display
	* the document structure provided by the KnetstartDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/
class KnetstartView : public QWidget
{
  Q_OBJECT
friend KnetstartDoc;
public:
  /** Constructor for the main view */
  KnetstartView(QWidget* parent = 0, const char* name=0);
  /** Destructor for the main view */
  ~KnetstartView();

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a KnetstartApp instance as a parent
		* widget to get to the window document pointer by calling the KnetstartApp::getDocument() method.
		*
		* @see KnetstartApp#getDocument
		*/
	KnetstartDoc* getDocument() const;
	
  /** contains the implementation for printing functionality */
	void print(QPrinter* m_pPrinter);

signals:
	void statusMsg(const char *);
	void statusHelpMsg(const char *);
	
protected slots:
	/** The Go button slot. Starts the configuration process */
	void slotGo();
	
	void slotDhcp(bool);
	void slotUsePubNs(const char* pubn);
		
protected:
	 IPinput *ip;
	 IPinput *gateway;
	 IPinput *ns;
	 QPushButton *go;
	 QCheckBox *dhcp;
	 /** Animated network map widget */
	 netmap *nmap;


};

#endif // KNETSTARTVIEW_H



































































