/***************************************************************************
                          mclient.h  -  description
                             -------------------
    begin                : Tue Aug 24 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MCLIENT_H
#define MCLIENT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <qwidget.h>
#include <qstring.h>
#include <qstrlist.h>


/**Class for connecting to server
  *@author Darren Poulson
  *@short All methods for communicating with the server are here
  */

int cwrapper(int *, struct sockaddr *, int *);



class MClient :public QWidget {
	Q_OBJECT
public: 
	/** Constructor */
	MClient(QWidget *parent = 0, const char *name = 0);

	/** Destructor */
	~MClient();

  /** Kill the current connection
	* @param none
	*/
  void Kill();

  /** Dial the given connection
  * @param cname Connection name to dial
  */
  void Dial(const char *);

  /** Connect to the modem server
	* @param host Hostname of server
	* @param	port Port number of server
	*/
	void ServerConnect(const char *, const char *);

  /** Check if client is connected to server
	* @param none
	* @return True or false, is the client connected to a server
	*/
  bool isConnected();

  /** Reads the time of the connection being established from the server
	* @param none
  */
  int readTime();

  /** Reads the status from the server
	* @param none
	*/
  void readStatus();

  /** Reads what the server thinks your IP address is.
	* @param none
	*/
  void readCIP();

  /** Reads the number of clients connected to the server
	* @param none
	*/
  int readCCount();

  /** Reads the current time from the server
	* @param none
	*/
  int readCTime();

  /** Send auth name and password and make sure its valid
	* @param user Username
	* @param pass Password
	*/
  void getAuth(const char *, const char *);
  /** Logs off the client from the server
	* @param none
	* @return none
  */
  void sendQuit();

  /** List all available connections */
  void List();

  /** Reads the connection information
	* @param cname Connection name to get info for
	* @return QString containing all the data
	*/
  QString *readCInfo(const char *);

private: // Private attributes

  /** Is there a server connection */
  bool server_connection;

	int sfd;

  /** is the connection locked? */
  bool islocked;

  /** Locks the connection
	* @param none
	* @return Boolean, either true or false.
	*/
  bool getlock();

  /** unlocks the connection
	* @param none
	* @return none
	*/
  void unlock();

  /** Waits for a READY from the server
	* @param none
	* @return none
	*/
  void getready();

  FILE *sock;


signals: // Signals

  /** A new connection option from server */
  void NewConnection(const char *);

	/** Sends server status messages */
	void ServerStatus(const char *);

	/** Is the a connection already dialed? */
	void DialedOut(bool);

};

#endif





























































