#!/usr/bin/env python

####################################################################
#                                                                  #
# The installer is (C) Martin P Holland 2000                       #
# I give unlimited permission to copy, distribute and modify it.   #
# No warranty is given or implied for the installer. You use it at #
# your own risk.                                                   #
#                                                                  #
####################################################################

import sys
import os
import compileall
import string

if len(sys.argv)==2:
    clidir=sys.argv[1]
else:
    clidir='/usr/local'
cliapp='ftpupdater'

datadir=clidir+'/share/'+cliapp+'/'

def installdir(d):
    "Install a directory"
    print 'Creating directory',d
    if os.system('install -d --owner=root --group=root --mode=755 '+d):
        print 'FAILED'

def installcontents(d,e,m='644'):
    "Install content of a directory"
    print 'Installing content in',e
    if os.listdir(d)==[]:
        print d,'is empty; nothing to do'
        return
    if os.system('install --owner=root --group=root --mode='+m+' ' +d+'/* '+e):
        print 'FAILED'

def installfile(f,e,m='644'):
    "Install a file"
    print 'Installing',e+f
    if os.system('install --owner=root --group=root --mode='+m+' ' +f+' '+e+f):
        print 'FAILED'

print 'Installing application called',cliapp

#create app data directory
installdir(datadir)

#install contents of app data directory
os.chdir('data')
for d in os.listdir('.'):
    if not os.path.isdir(d):
        installfile(d,datadir)
    else:
        installdir(datadir+d)
        installcontents(d,datadir+d)
os.chdir('..')

#compile python files
#print 'Compiling python'
#compileall.compile_dir(datadir+'python')

#Create redirecting shell script in /usr/local/bin for ftpupdater
f=open(cliapp,'w')
f.write('#!/bin/sh\n')
f.write('python '+datadir+'python/'+cliapp+'.py $*\n')
f.close()
installfile(cliapp,clidir+'/bin/','755')
os.remove(cliapp)
#install man page
installfile(cliapp+'.1',clidir+'/man/man1/','644')
