#ifndef __ONWEBSERVERPAGE_H__
#define __ONWEBSERVERPAGE_H__

#include <qfiledlg.h>
#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h>
#include "fileListBox.h" 
#include "kintegerline.h"
#include "ircClient.h"
#include <kconfig.h>
#include "webServer.h"
#include "dictPage.h"

class IrcClient;

class MimeTypePage : public DictPage
{
public:
  MimeTypePage(QDict<char>* dict, QWidget *parent = NULL, const char *name = NULL );
  ~MimeTypePage();
};

class OnWebServerPage : public QWidget
{
  Q_OBJECT
protected:
  WebServer*   webServer;
  QVBoxLayout* topLayout;
  QGridLayout* grid;
  QDict<QCheckBox>    checkBox;
  QDict<QButtonGroup> btnGroup;
  QDict<QGroupBox>    groupBox;
  QStrList            configText;
  QStrList            checkText;
  QDict<KIntegerLine> intLine;
  QLineEdit*          pathEdit;
  FileDirBox*         rootDirBox;
  FileDirBox*         cgiDirBox;
public:
  OnWebServerPage(WebServer* webServer, QWidget *parent = NULL, const char *name = NULL );
  ~OnWebServerPage();
signals:
protected:
  void    Init();
  void    readConfig();
  void    createConfigBox();
  void    createCheckBox();
  void    createPushButton();
protected slots:
  void slotApply();
};

#endif
