#ifndef __CMD_H__
#define __CMD_H__

#include <iostream.h>
#include <tcl.h>

#define STDVAR (ClientData cd, Tcl_Interp* irp, int argc, char** argv)
#define BADARGS(min, max, txt) \
  if ((argc<(min)) || (argc>(max))) { \
    Tcl_AppendResult(irp,"wrong # args: should be \"",argv[0], (txt),"\"",NULL);\
    return TCL_ERROR; \
  }

#define RET_ERROR(txt)  {\
    Tcl_AppendResult(irp,"wrong # args: should be \"",argv[0], (txt),"\"",NULL);\
    return TCL_ERROR; \
  }

int tcl_sleep      STDVAR ;
int tcl_nick       STDVAR ;
int tcl_server     STDVAR ;
int tcl_userinfo   STDVAR ;
int tcl_userhost   STDVAR ;
int tcl_userserver STDVAR ;
int tcl_userlist   STDVAR ;
int tcl_chanlist   STDVAR ;

int tcl_haveop        STDVAR ;
int tcl_sendraw       STDVAR ;
int tcl_sendserver    STDVAR ;
int tcl_sendchannel   STDVAR ;
int tcl_sendmsg       STDVAR ;
int tcl_sendnotice    STDVAR ;
int tcl_sendctcp      STDVAR ;
int tcl_sendctcpreply STDVAR ;
int tcl_sendmode      STDVAR ;

int tcl_addchanban    STDVAR ;

int tcl_writewnd      STDVAR ;
int tcl_writeactive   STDVAR ;
int tcl_addpage       STDVAR ;
int tcl_delpage       STDVAR ;
int tcl_writepage     STDVAR ;

int tcl_addfriend     STDVAR ;
int tcl_delfriend     STDVAR ;
int tcl_addban        STDVAR ;
int tcl_delban        STDVAR ;
int tcl_addignore     STDVAR ;
int tcl_delignore     STDVAR ;

int tcl_addproxy      STDVAR ;
int tcl_delproxy      STDVAR ;

int tcl_friendlevel   STDVAR ;
int tcl_banlevel      STDVAR ;
int tcl_isignore      STDVAR ;

int tcl_sendcmd       STDVAR ;

int tcl_bind          STDVAR ;
int tcl_unbind        STDVAR ;
int tcl_setopt        STDVAR ;
int tcl_getopt        STDVAR ;

int tcl_addtimer      STDVAR ;
int tcl_deltimer      STDVAR ;

int tcl_kexec         STDVAR ;
int tcl_kkill         STDVAR ;


#endif


