#include "ircDefine.h"
#include "ircClient.h"
#include "cmd.h"

int tcl_sleep STDVAR
{
#ifdef EDEBUG
  cout << "tcl_sleep"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," second");
  QString s=argv[1];
  bool ok;
  ulong sec=s.toULong(&ok);
  if (!ok){
     Tcl_AppendResult(irp,"wrong # args: should be number", NULL);
     return TCL_ERROR; 
  }
  client->Sleep(sec);
#ifdef EDEBUG
  cout << "tcl_sleep...Ok:"<<endl;
#endif
  return TCL_OK;
}

int tcl_nick STDVAR
{
#ifdef EDEBUG
  cout << "tcl_getnick"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  QString nick=client->curNick;
  Tcl_SetResult(irp, nick.data(), TCL_VOLATILE);

  return TCL_OK;
}

int tcl_server STDVAR
{
#ifdef EDEBUG
  cout << "tcl_getserver"<<endl;
#endif
  IrcClient* client = (IrcClient*)cd;
  IrcServer* is     = client->curServer;
  QString server = is->Host()+" "+is->Port();
  Tcl_SetResult(irp, server.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_userinfo STDVAR
{
#ifdef EDEBUG
  cout << "tcl_getuserinfo"<<endl;
#endif
  IrcClient* client = (IrcClient*)cd;
  BADARGS(2,2," nick");
  QString nick=argv[1];
  IrcUser* iu=client->getIrcUser(nick, 1);
  QString user="";
  if (iu!=0L)
     user = iu->nick()+" "+iu->user()+" "+iu->host()+" "+iu->server();
  Tcl_SetResult(irp, user.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_userhost STDVAR
{
#ifdef EDEBUG
  cout << "tcl_getuserhost"<<endl;
#endif
  IrcClient* client = (IrcClient*)cd;
  BADARGS(2,2," nick");
  QString nick=argv[1];
  IrcUser* iu=client->getIrcUser(nick, 0);
  QString host="";
  if (iu!=0L)
     host = iu->host();
  Tcl_SetResult(irp, host.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_userserver STDVAR
{
#ifdef EDEBUG
  cout << "tcl_getuserserver"<<endl;
#endif
  IrcClient* client = (IrcClient*)cd;
  BADARGS(2,2," nick");
  QString nick=argv[1];
  IrcUser* iu=client->getIrcUser(nick, 1);
  QString server="";
  if (iu!=0L)
     server = iu->server();
  Tcl_SetResult(irp, server.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_userlist STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," channel");
  QString chan = QString(argv[1]);
  QString list = "";
  IrcChannel* ic=client->channel->find(chan);
  if (!ic){
     RET_ERROR(" channel");
  }
  QDictIterator<ChannelUser> it (*ic->cuList);
  ChannelUser* cu;
  for (;(cu=it.current())!=0L;++it){
      list += QString(it.currentKey())+" ";
  }
  Tcl_SetResult(irp, list.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_chanlist STDVAR
{
  IrcClient* client=(IrcClient*)cd;

  QString list = "";
  QDictIterator<IrcChannel> it(*client->channel);
  IrcChannel* ic;
  for (;(ic=it.current())!=0L;++it){
      list += QString(it.currentKey())+" ";
  }
  Tcl_SetResult(irp, list.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_haveop STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," nick channel");
  QString nick = QString(argv[1]);
  QString chan = QString(argv[2]);
  IrcChannel* ic=client->channel->find(chan);
  if (!ic){
     RET_ERROR(" channel");
  }
  
  ChannelUser* cu=ic->cuList->find(nick);
  if (!cu){
     RET_ERROR(" user not in channel");
  }
  QString ret;
  if (cu->haveOp())
     ret="1";
  else
     ret="0";
  Tcl_SetResult(irp, ret.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_sendraw STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," text");
  QString s = "RAW "+QString(argv[1]);
  
  client->getSocket().parseLine(s);
  return TCL_OK;
}

int tcl_sendserver STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," text");
  QString s = QString(argv[1]);
  client->getSocket().parseLine(s);
  return TCL_OK;
}

int tcl_sendchannel STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," #channel text");
  client->slotCommand(QString(argv[1]), QString(argv[2]));

  //QString s = QString(argv[1])+" "+QString(argv[2]);
  //client->getSocket().sendPrivmsg(s);
  return TCL_OK;
}

int tcl_sendmsg STDVAR
{
#ifdef EDEBUG
  cout << "tcl_sendmsg"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," nick text");
  client->slotCommand(QString(argv[1]), QString(argv[2]));

  //QString s = QString(argv[1])+" "+QString(argv[2]);
  //client->getSocket().sendPrivmsg(s);
  return TCL_OK;
}

int tcl_sendnotice STDVAR
{
#ifdef EDEBUG
  cout << "tcl_sendnotice"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," to text");
  QString to=argv[1];
  QString  s="/NOTICE "+to+" "+QString(argv[2]);
  client->slotCommand(to, s);

  return TCL_OK;
}

int tcl_sendctcp STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," user text");
  QString to=argv[1];
  QString s ="/CTCP "+to+" "+QString(argv[2]);
  client->slotCommand(to, s);

  //QString s = QString(argv[1])+" "+QString(argv[2]);
  //client->getSocket().sendCtcp(s);
  return TCL_OK;
}

int tcl_sendctcpreply STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," user text");
  QString s = QString(argv[1])+" "+QString(argv[2]);
  client->getSocket().sendCtcpReply(s);
  return TCL_OK;
}

int tcl_sendmode STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," to mode [text]");
  QString s = QString(argv[1])+" "+QString(argv[2]);
  if (argc>3)
     s +=" "+QString(argv[3]);
  client->getSocket().sendMode(s);
  return TCL_OK;
}

int tcl_addchanban STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," ident channel <second>");
  QString ident = QString(argv[1]);
  QString chan  = QString(argv[2]);
  IrcChannel* ic=client->channel->find(chan);
  if (ic==0L){
     RET_ERROR(" channel");
  }
  ulong l = 0;
  if (argc==4)
     l=atol(argv[3]);
  ic->addBan(ident, l);
  return TCL_OK;
}

int tcl_sendcmd STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," cmd");
  client->slotInputParse(QString(argv[1]));

  return TCL_OK;
}

int tcl_writewnd STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," flag text <filter>");
  int  type   = atoi(argv[1]);
  bool parsen = true;
  if (argc==4)
     parsen = (atoi(argv[3])>0)?true:false;

  client->slotWriteMsg(type|TYPE_TCL, STR_CONVERT(argv[2]), parsen);
  return TCL_OK;
}

int tcl_writeactive STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," flag text <filter>");
  int  type   = atoi(argv[1]);
  bool parsen = true;
  if (argc==4)
     parsen = (atoi(argv[3])>0)?true:false;

  client->slotWriteOnActive(type|TYPE_TCL, STR_CONVERT(argv[2]),parsen);
  return TCL_OK;
}

int tcl_writepage STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(4,5," name flag text <filter>");
  int type = atoi(argv[2]);
  bool parsen = true;
  if (argc==5)
     parsen = (atoi(argv[4])>0)?true:false;

  client->slotWritePage(STR_CONVERT(argv[1]), type|TYPE_TCL, STR_CONVERT(argv[3]), parsen);
  return TCL_OK;
}

int tcl_addpage STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,3," name <detach>");
  QString name = STR_CONVERT(argv[1]);
  bool    detach;
  if (argc==2)
     detach=false;
  else
    detach=(atoi(argv[2])>0)?true:false;

  client->addOutputPage(name, MDI_DETACHED, detach);
  Tcl_SetResult(irp, name.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_delpage STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," name");
  QString name = STR_CONVERT(argv[1]);

  client->delOutputPage(name);
  return TCL_OK;
}

int tcl_addfriend STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," ident level <channel>");
  QString k = STR_CONVERT(argv[1]);
  QString l = STR_CONVERT(argv[2]);
  QString c;
  if (argc==4)
     c = STR_CONVERT(argv[3]);
  else
     c = "*";
  client->friendList->addUser(k, l.toInt(), c);
  return TCL_OK;
}

int tcl_delfriend STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," name");
  QString k = STR_CONVERT(argv[1]);

  client->friendList->delUser(k);
  return TCL_OK;
}

int tcl_addban STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," ident level <channel>");
  QString k = STR_CONVERT(argv[1]);
  QString l = STR_CONVERT(argv[2]);
  QString c;
  if (argc==4)
     c = STR_CONVERT(argv[3]);
  else
     c = "*";
  client->banList->addUser(k, l.toInt(), c);
  return TCL_OK;
}

int tcl_delban STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," name");
  QString k = STR_CONVERT(argv[1]);

  client->banList->delUser(k);
  return TCL_OK;
}

int tcl_addignore STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,4," ident flag <second>");
  QString k = STR_CONVERT(argv[1]);
  QString l = STR_CONVERT(argv[2]);
  QString c;
  if (argc==4)
     c = STR_CONVERT(argv[3]);
  else
     c = "0";
  client->ignList->addUser(k, l, c.toULong());
  return TCL_OK;
}

int tcl_delignore STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," name");
  QString k = STR_CONVERT(argv[1]);

  client->ignList->delUser(k);
  return TCL_OK;
}

int tcl_addproxy STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,5," host port <login> <passwd>");
  QString h = STR_CONVERT(argv[1]);
  QString p = STR_CONVERT(argv[2]);
  QString l, pa;
  if (argc<=4)
     l = STR_CONVERT(argv[3]);
  else
     l = "";
  if (argc<=5)
     pa = STR_CONVERT(argv[4]);
  else
     pa = "";
  client->clientSetup->proxyList()->addHost(h, p, l, pa);
  return TCL_OK;
}

int tcl_delproxy STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," host port");
  QString h = STR_CONVERT(argv[1]);
  QString p = STR_CONVERT(argv[2]);

  client->clientSetup->proxyList()->delHost(h, p);
  return TCL_OK;
}

int tcl_friendlevel STDVAR
{
#ifdef EDEBUG
  cout << "tcl_friendlevel"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,3," ident <channel>");
  QString i = STR_CONVERT(argv[1]);
  int ret=0;
  int status;
  if (argc==3)
     status=client->friendList->matchUser(i, 0, true, STR_CONVERT(argv[2]), &ret);
  else
     status=client->friendList->matchUser(i, 0, true, 0L, &ret);
  i.setNum(ret);
  Tcl_SetResult(irp, i.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_banlevel STDVAR
{
#ifdef EDEBUG
  cout << "tcl_banlevel"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,3," ident <channel>");
  QString i = STR_CONVERT(argv[1]);
  int ret=0;
  int status;
  if (argc==3)
     status=client->banList->matchUser(i, 0, true, STR_CONVERT(argv[2]), &ret);
  else
     status=client->banList->matchUser(i, 0, true, 0L, &ret);
  i.setNum(ret);
  Tcl_SetResult(irp, i.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_isignore STDVAR
{
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," ident flags");
  QString i = argv[1];
  QString j = argv[2];
  int status = client->ignList->matchUser(i, j, true);
  i.setNum(status);
  Tcl_SetResult(irp, i.data(), TCL_VOLATILE);
  return TCL_OK;
}

int tcl_bind STDVAR
{
#ifdef EDEBUG
  cout << "tcl_bind"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(4,4," type cmdName procName");

  TclCmd* tclCmd=client->tclCmd;
  if (tclCmd->cmdBind(argv[1], argv[2], argv[3])<1){
     Tcl_AppendResult(irp,"bad type, should be one of: dcc, msg, ctcp",NULL);
     return TCL_ERROR;
  }
  Tcl_AppendResult(irp, argv[2], NULL);
#ifdef EDEBUG
  cout << "tcl_bind...Ok"<<endl;
#endif
  return TCL_OK;
}
                                            
int tcl_unbind STDVAR
{
  BADARGS(4,4," type cmdName procName");
  
  IrcClient* client=(IrcClient*)cd;

  TclCmd* tclCmd=client->tclCmd;
  if (tclCmd->cmdUnbind(argv[1], argv[2], argv[3])<1){
     Tcl_AppendResult(irp,"bad type, should be one of: dcc, msg, ctcp",NULL);
     return TCL_ERROR;
  }
  Tcl_AppendResult(irp, argv[2], NULL);
  return TCL_OK;
}

int tcl_setopt STDVAR
{
#ifdef EDEBUG
  cout << "tcl_setopt"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(3,3," var value");

  TclCmd* tclCmd=client->tclCmd;
  tclCmd->cmdSetOpt(argv[1], argv[2]);

  Tcl_AppendResult(irp, argv[2], NULL);
#ifdef EDEBUG
  cout << "tcl_setopt...Ok"<<endl;
#endif
  return TCL_OK;
}

int tcl_getopt STDVAR
{
#ifdef EDEBUG
  cout << "tcl_setopt"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," var");

  TclCmd* tclCmd=client->tclCmd;
  if (tclCmd->cmdGetOpt(argv[1])<1)
     RET_ERROR("var ");

#ifdef EDEBUG
  cout << "tcl_getopt...Ok"<<endl;
#endif
  return TCL_OK;
}

int tcl_addtimer STDVAR
{
#ifdef EDEBUG
  cout << "tcl_addtimer"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(4,4," flags second procName");

  TclCmd* tclCmd=client->tclCmd;
  long handle;
  if ((handle=tclCmd->cmdAddTimer(argv[1], argv[2], argv[3]))<1){
     Tcl_AppendResult(irp,"bad args, should be flags second procName", 0L);
     return TCL_ERROR;
  }
  QString s; s.setNum(handle);
  Tcl_SetResult(irp, s.data(), TCL_VOLATILE);
  return TCL_OK;
}
   
int tcl_deltimer STDVAR
{
#ifdef EDEBUG
  cout << "tcl_deltimer"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  if (argc==2){
     TclCmd* tclCmd=client->tclCmd;
     tclCmd->cmdDelTimer(argv[1]);
     return TCL_OK;
  }
  else if (argc==4){
     TclCmd* tclCmd=client->tclCmd;
     tclCmd->cmdDelTimer(argv[1], argv[2], argv[3]);
     return TCL_OK;
  }
  
  Tcl_AppendResult(irp,"wrong # args: should be \"",argv[0], "(handle or flag second proc)","\"",NULL);
  return TCL_ERROR;
}



int tcl_kexec STDVAR
{
#ifdef EDEBUG
  cout << "tcl_kexec"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,4," <programm argument> <flag> <proc>");
  char* flag=0L;
  char* proc=0L;
  if (argc==4){
     flag=argv[2];
     proc=argv[3];
  }
  TclCmd* tclCmd=client->tclCmd;
  long handle;
  if ((handle=tclCmd->cmdAddExec(argv[1], flag, proc))<1){
     Tcl_AppendResult(irp,"bad args, should be <program argument> <flag> <proc>", 0L);
     return TCL_ERROR;
  }
  QString s; s.setNum(handle);
  Tcl_SetResult(irp, s.data(), TCL_VOLATILE);
  return TCL_OK;
}
   
int tcl_kkill STDVAR
{
#ifdef EDEBUG
  cout << "tcl_kkill"<<endl;
#endif
  IrcClient* client=(IrcClient*)cd;
  BADARGS(2,2," handle");
  TclCmd* tclCmd=client->tclCmd;
  tclCmd->cmdDelExec(argv[1]);
  return TCL_OK;
}



