#ifndef __ONMEDIA_H__
#define __ONMEDIA_H__

#include <qlayout.h>
#include <qbttngrp.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qdatetm.h>
#include <qtimer.h>
#include <qdict.h>
#include <qfiledlg.h> 
#include <qcombo.h> 
#include "ircLine.h"
#include "fileListBox.h"

class IrcClient;

class OnMedia : public QWidget
{
  Q_OBJECT
protected:
  IrcClient*   client;
  KTabListBox* listBox;
  QVBoxLayout* verLayout;
  QHBoxLayout* horLayout;
  
public:
  MediaDialog(IrcClient* Client, bool Modal=TRUE, QWidget *parent=NULL, const char *name=NULL);
  ~MediaDialog();
protected:
  void    readConfig();
  void    createButton();
  void    createFileBox();
protected slots:
  void slotPlayRemote();
  void slotPlayLocal();
  void slotRefresh();
  void slotStop();
  void slotOk();
  void slotCancel();
public slots:
  virtual void show(const char* to=NULL);
};

#endif




