#include "StringToken.h"
#include "privMsgPage.h"
#include "privMsgPage.moc"
#include "ircDefine.h"
#include <qregexp.h>

#include <iostream.h>
#include <qlayout.h>
#include "ircApp.h"

PrivMsgPage::PrivMsgPage(IrcClient* Client, QWidget* parent, const char* Name) :
             OutputPage(Client, parent, Name)
{
#ifdef EDEBUG
  cout << "PrivMsgPage Konstruktor:"<<Name<<endl;
#endif
  privMsgClient  = client->privMsg->find(Name);
  if (!privMsgClient){
     cout << "PrivMsg Object: " << Name <<" cannot be found" << endl;
     return;
  }

  connect(inpCmd, 
	  SIGNAL(signReturn(const char*)), 
	  privMsgClient, 
	  SLOT  (slotInputParse(const char*)));
  connect(privMsgClient, 
	  SIGNAL(signWriteMsg(int, const char*, bool)), 
	  SLOT(slotWriteMsg  (int, const char*, bool)));

  createMenu();
  createToolbar(); 
  createPopup();
}

PrivMsgPage::~PrivMsgPage()
{
#ifdef EDEBUG
  cout << "Destruktor PrivMsgPage" << endl;
#endif;
}

void PrivMsgPage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("PrivMsg")))
     popup = client->popup.find("Default");

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotPrivMsgPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotPrivMsgPopupAction(const char*)));
  }
}

void PrivMsgPage::slotPrivMsgPopup(const char*, const QPoint& pos)
{
#ifdef EDEBUG
  cout <<"PrivMsgPage::slotPrivMsgPopup:"+QString(privMsgClient->name())<<endl;
#endif
  IrcPopup* popup = client->popup.find("PrivMsg");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void PrivMsgPage::slotPrivMsgPopupAction(const char* Action)
{  
  if ( IsSelected()==true && isActiveWindow()==true)
     privMsgClient->slotInputParse(Action);

  return;
}

void PrivMsgPage::Init()
{
}

void PrivMsgPage::createMenu()
{

}

void PrivMsgPage::createToolbar()
{
}

void PrivMsgPage::slotExit(MDIWindow*)
{
  client->delPrivMsg(privMsgClient->name(), false);
}

IrcPrivMsg* PrivMsgPage::getClient()
{
  return privMsgClient;
}

void PrivMsgPage::slotWriteMsg(int type, const char* txt, bool parse)
{
  htmlMsg->slotWrite(type, txt, parse);
  if (!IsSelected())
    emit signNewMsg();
}

