#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "ircBell.h"
#include "onPrivMsgPage.h"
#include "onPrivMsgPage.moc"
#include "ircApp.h"

void OnPrivMsgPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnPrivMsgPage::OnPrivMsgPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createPushButton();
  IrcBell* ib;
  QString  es="PrivMsgBell";
  client->bell.insert(es, ib=new IrcBell(client, es, this));
  grid->addWidget(ib, 1, 1);
  topLayout->activate();
  readConfig();
  show();
}

OnPrivMsgPage::~OnPrivMsgPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnPrivMsgPage" << endl;
#endif
}


void OnPrivMsgPage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );
  bg->setExclusive(TRUE);
  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoAccept"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Accept", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Ignore"));
  radioBtn.insert(entry, rb = new QRadioButton("Ignore it", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  vbox->addSpacing(bg->fontMetrics().height());
  //bg->setFixedWidth(bg->sizeHint().width());
  vbox->activate();
}

void OnPrivMsgPage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());

  QLabel* label;
  KIntegerLine* il;

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max Privmsg Client", gb);
  hbox->addWidget(label,5);
  configText.append(entry="PrivMsgClientMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max Dialog", gb);
  hbox->addWidget(label,5);
  configText.append(entry="PrivMsgDlgMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Dialog Timeout [second]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="PrivMsgDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  vbox->addStretch(10);
  gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}



void OnPrivMsgPage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnPrivMsgPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnPrivMsgPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;
  
  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);
  entry = "OnPrivMsg";
  value = ircapp->readEntry(entry, "AutoAccept");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);

  // max ircclient
  entry = "PrivMsgClientMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // max window
  entry = "PrivMsgDlgMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "PrivMsgDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);
}

void OnPrivMsgPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnPrivMsgPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnPrivMsg";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  entry = "PrivMsgClientMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  entry = "PrivMsgDlgMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "PrivMsgDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  client->bell["PrivMsgBell"]->slotApply();
}








