#include <iostream.h>
#include "fileReader.h"
#include "onChannelPage.h"
#include "ircBell.h"
#include "ircApp.h"

OnChannelAction::OnChannelAction(IrcClient* client, QWidget* parent, const char* name)
  : QWidget(parent, name)
{
  mClient = client;

  mStrBanType.setAutoDelete(true);
  createPage();
  readConfig();
  show();
}

OnChannelAction::~OnChannelAction()
{
}

void OnChannelAction::readConfig()
{
  QString val;
  QStrList varList;
  varList.setAutoDelete(true);
  for (int i=0;i<5;i++){
      val.setNum(i);
      varList.append("BanType"+val);
  }

  val=ircapp->readEntry("KickMessage", "kEirc");
  mEditKick->setText(val);

  val=ircapp->readEntry("BanType0", "*!*user@host.domain.tld");
  mStrBanType.append(val);
  val=ircapp->readEntry("BanType1", "*!*@host.domain.tld");
  mStrBanType.append(val);
  val=ircapp->readEntry("BanType2", "*!*user@*.domain.tld");
  mStrBanType.append(val);
  val=ircapp->readEntry("BanType3", "*!*@*.domain.tld");
  mStrBanType.append(val);
  val=ircapp->readEntry("BanType4", "*!*@*.tld");
  mStrBanType.append(val);

  
  mComboBanType->insertStrList  (&varList);

  val=ircapp->readEntry("BanType", "BanType0");
  mEditBanType->setText(mStrBanType.at(0));
  int idx;
  for (idx=0;idx<mComboBanType->count();idx++){
     if (!stricmp(val, mComboBanType->text(idx))){
        mComboBanType->setCurrentItem(idx);
        mEditBanType->setText(mStrBanType.at(idx));
        break;
     }
  }
}


void OnChannelAction::createPage()
{
  QVBoxLayout* topLayout = new QVBoxLayout(this, 10);

  QGroupBox*   gb = new QGroupBox(this);
  topLayout->addWidget(gb);
  QVBoxLayout* verLayout = new QVBoxLayout(gb, 10);
  QHBoxLayout* hbox;
  QLabel*      label;
  hbox = new QHBoxLayout(5);
  verLayout->addLayout(hbox);
  
  label = new QLabel("Kick Message :", gb);
  hbox->addWidget(label, 2);
  label->setFixedHeight(25);
  mEditKick = new QLineEdit(gb);
  hbox->addWidget(mEditKick, 5);
  mEditKick->setFixedHeight(25);

  hbox = new QHBoxLayout(5);
  verLayout->addLayout(hbox);

  label = new QLabel("Ban Type :", gb);
  hbox->addWidget(label, 2);
  label->setFixedHeight(25);
  mComboBanType = new QComboBox(FALSE, gb);
  hbox->addWidget(mComboBanType, 5);
  mComboBanType->setFixedHeight(25);
  connect(mComboBanType, SIGNAL(activated(int)),
	  SLOT(slotBanTypeActivated(int)));

  hbox = new QHBoxLayout(5);
  verLayout->addLayout(hbox);
  label= new QLabel("", gb);
  hbox->addWidget(label, 2);
  label->setFixedHeight(25);
  mEditBanType = new QLineEdit(gb);
  hbox->addWidget(mEditBanType, 5);
  mEditBanType->setFixedHeight(25);

  verLayout->activate();

  topLayout->addSpacing(5);
  hbox = new QHBoxLayout(5);
  topLayout->addLayout(hbox);

  QPushButton* btn;
  btn = new QPushButton( "Apply", this);
  hbox->addWidget(btn);
  btn->setFixedSize(100, 25);
  connect( btn, SIGNAL(clicked()), this, SLOT(slotApply()));
  hbox->addStretch(10);

  topLayout->addStretch(10);
  topLayout->activate();
}

void OnChannelAction::slotBanTypeActivated(int idx)
{
  QString s=mStrBanType.at(idx);
  mEditBanType->setText(s);
}

void OnChannelAction::slotApply()
{
  QString var, val;
  val=mEditKick->text();
  if (!val.isEmpty())
     ircapp->writeEntry("KickMessage", val);

  val=mComboBanType->currentText();
  ircapp->writeEntry("BanType", val);
}

void OnInvitePage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnInvitePage::OnInvitePage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createPushButton();

  IrcBell* ib;
  QString  es="InviteBell";
  client->bell.insert(es, ib=new IrcBell(client, es, this));
  grid->addWidget(ib, 1, 1);

  topLayout->activate();
  readConfig();
  show();
}

OnInvitePage::~OnInvitePage()
{
#ifdef EDEBUG
  cout << "Destruktor OnInvitePage" << endl;
#endif
}


void OnInvitePage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoJoin"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Join", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Ignore"));
  radioBtn.insert(entry, rb = new QRadioButton("Ignore it", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  //bg->setFixedHeight(4*bg->fontMetrics().height());
  vbox->activate();
}

void OnInvitePage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());
  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);

  QLabel* label;
  KIntegerLine* il;

  label = new QLabel("Max Accepted Invite", gb);
  hbox->addWidget(label,5);
  configText.append(entry="InvDlgMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Dialog Timeout [second]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="InvDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  vbox->addStretch(10);
  gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}



void OnInvitePage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnInvitePage::readConfig()
{
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);
  entry = "OnChannelInvite";
  value = ircapp->readEntry(entry, "Dialog");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);
  
  // max window
  entry = "InvDlgMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "InvDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);
}

void OnInvitePage::slotApply()
{
#ifdef EDEBUG
  cout << "OnInvitePage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnChannelInvite";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  // maxCount
  entry = "InvDlgMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "InvDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  client->bell["InviteBell"]->slotApply();
}


void OnKickPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnKickPage::OnKickPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createPushButton();

  IrcBell* ib;
  QString  es="KickBell";
  client->bell.insert(es, ib=new IrcBell(client, es, this));
  grid->addWidget(ib, 1, 1);

  topLayout->activate();
  readConfig();
  show();
}

OnKickPage::~OnKickPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnKickPage" << endl;
#endif
}


void OnKickPage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoJoin"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Join", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Quiet"));
  radioBtn.insert(entry, rb = new QRadioButton("Quiet", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  //bg->setFixedHeight(4*bg->fontMetrics().height());
  vbox->activate();
}

void OnKickPage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());
  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);

  QLabel* label;
  KIntegerLine* il;

  label = new QLabel("Dialog Timeout [second]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="KickDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  vbox->addStretch(10);
  gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}



void OnKickPage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnKickPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnKickPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);
  
  entry = "OnChannelKick";
  value = ircapp->readEntry(entry, "Quiet");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);
  
  // timeout
  entry = "KickDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);
}

void OnKickPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnKickPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnChannelKick";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  // timeout
  entry = "KickDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  client->bell["KickBell"]->slotApply();
}

#include "onChannelPage.moc"
