#include <iostream.h>
#include "StringToken.h"
#include "ircClient.h"
#include "ircPrivMsg.h"
#include "ircPrivMsg.moc"
#include "ircDefine.h"


IrcPrivMsg::IrcPrivMsg(const char* User, QObject* Parent, const char* Name):
  ClientCore(Parent, Name)
{
  firstJoin = 1;
  client = (IrcClient*)Parent;
  if (!User)
     return;
  user    = new IrcUser(User);
  setName(user->nick());
  start();
}


IrcPrivMsg::~IrcPrivMsg()
{
#ifdef EDEBUG
  cout << "Destruktor IrcPrivMsg" << endl;
#endif
  delete user;
}

QString IrcPrivMsg::cmdSubstitution(const char* Txt)
{
  QDict<char> list;
  list.setAutoDelete(true);
  list.insert("$u",    qstrdup(name()));
  list.insert("$to",   qstrdup(name()));
  return ClientCore::cmdSubstitution(list, Txt);
}


int IrcPrivMsg::changeNick(const char* nick, const char* NewNick)
{
#ifdef EDEBUG
  cout << "IrcPrivMsg::changeNick:"<<nick<<":"<<NewNick<<endl;
#endif
  QString onick = nick;
  QString nnick = NewNick;
  emit signChangeNick(nnick);
  QString s;
  s = onick+" is now known as "+nnick; 
  slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  setName(nnick);
  return 1;      
}

void IrcPrivMsg::setUser(const char* Nick, const char* User, const char* Host)
{
#ifdef EDEBUG
  cout << "IrcPrivMsg::setUser"<<endl;
#endif
  QString s=user->user();
  if (s.isNull()||s.isEmpty){
     user->setNick(Nick);
     user->setUser(User);
     user->setHost(Host);
  }
}

int IrcPrivMsg::onMsg(const char* Who, const char* Txt)
{
#ifdef EDEBUG
  cout << "IrcPrivMsg:"<<Who<<":"<<Txt<<endl;
#endif
  QString who = Who;
  StringToken tf(Who);
  StringToken tt(Txt);
  QString nick=tf.nextToken(" !");
  int Type;
  if (nick==mNick)
     Type=TYPE_TEXT;
  else
     Type=TYPE_MSG;

  QString t=tt.nextToken();
  QString s="";
  s += 0x02;
  if (t=="ACTION"){
     s += nick+0x02+" "+tt.toEnd("\n").remove(0, 1);
     emit signWriteMsg(TYPE_ACTION|TYPE_IMG, s, 1);
  }
  else{
     s += "<"+nick+">"+0x02+" ";
     s += Txt;
     emit signWriteMsg(Type, s, 1);
  }
  
  // From me
  if (Type==TYPE_TEXT)
     return 1;

  checkFlood(Who);
  return 1;      
}

void IrcPrivMsg::slotInputParse(const char* Txt)
{
  QString inp = client->alias->eval(Txt);
  inp = cmdSubstitution(inp);
  if (inp.isEmpty())
     return;
  emit signCommand(name(), inp);
}

bool IrcPrivMsg::checkFlood(const char* Who)
{
  QString who = Who;
  StringToken st(Who);
  QString nick=st.nextToken(" !");
  // Check Flood
  int inSecond, maxLine;
  QString entry, value;
  entry = "FloodProtectionActivate"; value = ircapp->readEntry(entry, "Yes");
  if (value=="No")
     return 0;

  entry = "FLOOD_SECOND"; value = ircapp->readEntry(entry, "1");
  inSecond = value.toInt();
  entry = "FLOOD_MAXLINE"; value = ircapp->readEntry(entry, "3");
  maxLine = value.toInt();
  bool status=user->checkFlood(inSecond, maxLine);
#ifdef TCL
  entry="BIND_FLOOD";
  value=ircapp->readEntry(entry, "Yes");
  if (status==true && value=="Yes"){
     QStrList funcName;
     funcName.setAutoDelete(TRUE);
     int nTcl=client->tclCmd->getBindProc("FLOOD", "p", funcName);
     if (nTcl){
       QString argv = nick+" p "+who;
       client->tclCmd->evalCmd(funcName, argv);
     }
  }
#endif
  return status;
}



