#include <iostream.h>
#include <qlayout.h>
#include "StringToken.h"
#include "ircDialog.h"
#include "ircApp.h"

// 22.04.98
// Dialog must be modal

// name wird als from implementiert

IrcDialog::IrcDialog(IrcClient* Client, 
		     const char* TOEntry, 
		     const char* MaxEntry,
		     const char* CurEntry,
		     const char* Caption,
		     const char* Text,
		     const char* Command,
		     bool Modal, 
		     QWidget *parent, 
		     const char *name)
  : QDialog(parent, name, Modal)
{
  client = Client;
  this->TOEntry  = TOEntry;
  this->MaxEntry = MaxEntry;
  this->CurEntry = CurEntry;
  this->Text     = Text;
  this->Command  = Command;
  this->Caption  = Caption;
  createDialog();
}

IrcDialog::IrcDialog(IrcClient* Client, 
		     QDict<char>& Property, 
		     bool Modal, 
		     QWidget *parent, 
		     const char *name )
     : QDialog( parent, name, Modal)
{
    client   = Client;
    TOEntry  = Property["TOEntry"]; 
    MaxEntry = Property["MaxEntry"];
    CurEntry = Property["CurEntry"];
    Caption  = Property["Caption"];
    Text     = Property["Text"];
    Command  = Property["Command"];
    createDialog();
}

void IrcDialog::createDialog()
{
#ifdef EDEBUG
  cout<< "IrcDialog::createDialog()"<<endl;
#endif
  int max;
  timeout = ircapp->readNumEntry(TOEntry, 30);
  if (!MaxEntry.isEmpty() && !CurEntry.isEmpty()){
     max      = ircapp->readNumEntry(MaxEntry, 5);
     curCount = ircapp->readNumEntry(CurEntry, 0);
     if (curCount >= max)
        curCount = 1;
     else
        ircapp->writeEntry(CurEntry, ++curCount);
  }

  setFixedSize(350, 125);
  QBoxLayout* vlayout;
  QBoxLayout* hlayout;
  vlayout = new QVBoxLayout(this, 10);

  hlayout = new QHBoxLayout(0);
  vlayout->addLayout(hlayout, 4);

  lcd = new QLCDNumber(this); 
  QString TO;
  interval = 1000; // 1 second

  lcd->setBackgroundColor(QColor(blue));
  lcd->setSegmentStyle(QLCDNumber::Outline);
  lcd->display(timeout);
  lcd->setFixedHeight(25);
  hlayout->addWidget (lcd,1, AlignCenter);

  QLabel* label = new QLabel(Text, this);
  label->setAlignment(AlignCenter);
  label->adjustSize();
  label->setFont( QFont("times", 12, QFont::Bold));
  hlayout->addWidget(label, 6);

  QFrame* frame = new QFrame(this);
  frame->setLineWidth(1);
  frame->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  vlayout->addWidget(frame, 1);

  hlayout = new QHBoxLayout;
  vlayout->addLayout(hlayout, 3);
  QPushButton* ok, *cancel, *ignore;
  ok = new QPushButton( "Ok", this );
  hlayout->addStretch(2);
  hlayout->addWidget(ok, 1);

  connect( ok, SIGNAL(clicked()), this, SLOT(slotOk()));

  cancel = new QPushButton( "Cancel", this );
  hlayout->addWidget(cancel, 1);
  connect(cancel, SIGNAL(clicked()), this, SLOT(slotCancel()));

  if (name() && strlen(name())>0){
     ignore = new QPushButton( "Ignore", this );
     hlayout->addWidget(ignore, 1);
     connect(ignore, SIGNAL(clicked()), this, SLOT(slotIgnore()));
  }

  hlayout->addStretch(2);
  vlayout->activate();
    
  timer = new QTimer(this);
  connect(timer, SIGNAL(timeout()), SLOT(slotTimeout()));
  setCaption(Caption);
  if (timeout>0)
     timer->start(interval, FALSE);
}

IrcDialog::~IrcDialog()
{
  if (timer->isActive())
     timer->stop();
}

void IrcDialog::slotTimeout()
{
  timeout--;
  if (timeout<1){
     timer->stop();
     slotCancel();
     return;
  }
  lcd->display(timeout);
}

void IrcDialog::slotOk()
{
  StringToken t(Command, "\n");
  QString cmd;
  while(t.hasMoreTokens()){
    cmd = t.nextToken();
    cmd = cmd.simplifyWhiteSpace();
    if (!cmd.isEmpty())
      client->slotInputParse(cmd);
  }
  accept();
}

void IrcDialog::slotCancel()
{
  if (!CurEntry.isEmpty()){
    ircapp->writeEntry(CurEntry, --curCount);
  }
  reject();
}


void IrcDialog::slotIgnore()
{
  if (!CurEntry.isEmpty()){
    ircapp->writeEntry(CurEntry, --curCount);
  }
  if (name() && strlen(name())>0){
     StringToken tf(name());
     QString nick=tf.nextToken(" !");
     QString user=tf.nextToken("!@");
     if (user[0]=='~')
        user.remove(0, 1);
     QString host=tf.nextToken(" @");
     // Ignore 120 seconds, private, invite, dcc file, dcc chat
     client->ignList->addUser("*!*"+user+"@"+host, "pinfts", 120);
  }
  reject();
}


#include "ircDialog.moc"



