#ifndef __IRCBAN_H__
#define __IRCBAN_H__ 

#include <qstring.h>
#include "ircUser.h"
#include "ircCore.h"

class IrcBan : public IrcCore
{
protected:
  QString mBanned;
  QString mBy;
public:
  IrcBan(const char* Ban, const char* By, ulong howLong=0);
  IrcBan(const char* BanStr, ulong howLong=0);
  QString ban();
};

class BanList;

class BanUser : public FriendUser
{
  friend class BanList;
protected:
  QString mReason;
  ulong   mSecond;
  bool    mTemporary;
public:
  BanUser(const char* ident, int level, const char* channel="*", ulong second=0);
  virtual ~BanUser();
  ulong getSecond(){
    return mSecond;
  }
  void  setSecond(ulong l){
    mSecond=l;
  }
  void  decSecond(){
    mSecond--;
  }
  void  incSecond(){
    mSecond++;
  }
};


class BanList : public FriendList
{
public:
  BanList(IrcClient* client);
  ~BanList();
  BanUser* getUser(const char* ident, bool wildcard=false);
  BanUser* addUser(const char* ident, int level, const char* channel="*", ulong second=0);
  void     delUser(const char* ident, bool wildcard=false);
  virtual  void     checkUser();
  BanUser* first(){
    return (BanUser*)(FriendList::first());
  }
  BanUser* next(){
    return (BanUser*)(FriendList::next());
  }
  BanUser* current(){
    return (BanUser*)(FriendList::current());
  }
};

class IgnoreList;

class IgnoreUser : public BanUser
{
  friend class IgnoreList;
protected:
  // p=private msg, c=channel, n=notice, f=dccfile, t=dccchat, s=ctcpsound
  QString mIgnFlag;
  void setIgnFlag(const char*);
public:
  IgnoreUser(const char* ident, const char* flag="p", ulong second=0);
  virtual ~IgnoreUser();
  QString getIgnFlag(){
    if (mIgnFlag.isEmpty())
       return "";
    return mIgnFlag;
  }
};

class IgnoreList : public BanList
{
public:
  IgnoreList(IrcClient* client);
  ~IgnoreList();
  IgnoreUser* getUser(const char* ident, bool wildcard=false);
  IgnoreUser* addUser(const char* ident, const char* flag="p", ulong second=0);
  int      matchUser(const char* ident, const char* flag, bool wildcard=true);
  void     delUser(const char* ident, bool wildcard=false);
  virtual  void     checkUser();
  IgnoreUser* first(){
    return (IgnoreUser*)(FriendList::first());
  }
  IgnoreUser* next(){
    return (IgnoreUser*)(FriendList::next());
  }
  IgnoreUser* current(){
    return (IgnoreUser*)(FriendList::current());
  }
};

#endif




