#include <iostream.h>
#include <stdlib.h>
#include <qregexp.h> 
#include <qstrlist.h>
#include <qtstream.h> 
#include <qfile.h> 
#include "StringToken.h" 
#include "ircAlias.h"
#include "ircAlias.moc"
#include "fileReader.h"
#include "ircApp.h"

IrcAlias::IrcAlias() : QObject()
{
  alias = new QDict<char>(20, FALSE, TRUE);
  alias->setAutoDelete(true);
  path = "kEirc.alias";
  entry= "";
}

IrcAlias::IrcAlias(const char* Entry, const char* Path)
{
  alias = new QDict<char>(20, FALSE, TRUE);
  alias->setAutoDelete(true);
  entry = Entry;
  path  = ircapp->readPathEntry(entry, Path); 
  load();
}

IrcAlias::~IrcAlias()
{
  delete alias;
}

int IrcAlias::load(const char* File)
{
  QStrList list;
  FileReader fr(&list, entry, path);
  if (!fr.load(File))
     return 0;
  path = fr.getPath();

  alias->clear();
  for (list.first();list.current();list.next())
    add(list.current());
  emit signUpdateData();
  return 1;
}

int IrcAlias::save(const char* File)
{
  FileReader fr(alias, entry, path);
  if (!fr.save(File))
     return 0;
  path = fr.getPath();
  return 1;
}

void IrcAlias::add(const char* Cmd, const char* Value)
{
  if (!Cmd || !Value)
     return;
  if (alias->find(Cmd))
     alias->remove(Cmd);
  alias->insert(Cmd, qstrdup(Value));
}

void IrcAlias::add(const char* Txt)
{
  if (!Txt)
     return;
  QString s(Txt);
  s = s.stripWhiteSpace();
  if (s.isEmpty())
     return;
  StringToken t(s);
  QString cmd=t.nextToken();
  QString val=t.toEnd();
  add(cmd, val);
}

void IrcAlias::clear()
{
  alias->clear();
}

QString IrcAlias::getPath()
{
  return path;
}

QString IrcAlias::getEntry()
{
  return entry;
}

// op   mode $1 +o $2
// op   #lesehan gudeg
// mode #lesehan +o gudeg
QString IrcAlias::eval(const char* Alias)
{
#ifdef EDEBUG
  cout << "IrcAlias::eval:"<<Alias<<endl;
#endif
  StringToken t(Alias);
  QString cmd   = t.nextToken();
  QString param = t.toEnd();
  QString value;
  if (cmd.isEmpty())
     return "";
  if (!(value=alias->find(cmd)))
     return Alias;
  QStrList paramList;
  paramList.append(cmd);
  while (t.hasMoreTokens())
    paramList.append(t.nextToken());

  int idx=-1;
  while((idx=value.find('$', idx+1, FALSE))>=0){
    if (idx!=0 && value[idx-1]=='\\')
       continue;
    QRegExp reg("[0-9]", FALSE, FALSE);
    QString v;
    v.sprintf("%c", value[idx+1]);
    if (reg.match(v, 0)>=0)
       value.replace(idx, 2, paramList.at(v.toInt()));
    else if (value[idx+1]=='-')
       value.replace(idx, 2, param);
  }
  return value;
}

QDict<char>* IrcAlias::getList()
{
  return alias;
}

void IrcAlias::setEntry(const char* Entry)
{
  entry = Entry;
}
