#ifndef __HTMLCONTENT_H__
#define __HTMLCONTENT_H__

#include <qstring.h>
#include <qstrlist.h>
#include <qobject.h>
#include <html.h>

class HtmlContent : public QObject
{
  Q_OBJECT
protected:
  KHTMLWidget* htmlw;
  QStrList     buffer;
  QString      bgImage;
  QString      bgColor;
  int          size;
  int          curSize;
  HtmlContent* prev;
signals:
  void signNextBuffer(const char* Txt);
public:
  HtmlContent(KHTMLWidget* htmlw, int size=75);
  ~HtmlContent(){};
  void    writeBuffer(const char* Txt);
  void    write(const char* Txt);
  void    start(const char* bgImage=0L, const char* bgColor=0L);
  void    showHtml(bool showPrev=false);
  void    setBgImage(const char* str);
  void    setBgColor(const char* str);
  void    setPrev(HtmlContent*);
  QStrList& list();
};

#endif

