#include <iostream.h>
#include "StringToken.h"
#include "dccChatPage.h"
#include "ircView.h"
#include "dccFileTab.h"
#include "dccFileTab.moc"
#include "colorOpt.h"
#include "fontOpt.h"
#include "optPrefDialog.h"

#include <iostream.h>
#include <qlayout.h>

DCCFileTab::DCCFileTab(IrcClient* Client, QWidget* parent, const char* Name):
  PageTab(Client, parent, Name)
{
  connect(client, 
	  SIGNAL(signAddDCCFile(const char*)),
	  this,
	  SLOT  (slotAddDCCFile(const char*)));

  show();
}

DCCFileTab::~DCCFileTab()
{
#ifdef EDEBUG
  cout << "Destruktor DCCFileTab" << endl;
#endif
}

void DCCFileTab::slotAddDCCFile(const char* Name)
{
#ifdef EDEBUG
  cout << "DCCFileTab::slotAddDCCFile:" << Name<<endl;
#endif
  DCCFilePage* dfp;
  QString s=Name;
  treeList->insertItem(s, 0, treeList->currentItem());
  
  pageWidget->hide();

  QString  value;
  value = ircapp->readEntry("DCCFileWindowDetach", "No");
  if (value.find( "No", 0, false ) == 0){
     dfp=new DCCFilePage(client, pageWidget, Name);
     dfp->vbox = new QVBoxLayout(pageWidget,0);
     dfp->vbox->addWidget(dfp);
     dfp->vbox->activate();
  }
  else{
     dfp=new DCCFilePage(client, 0L, Name);
     dfp->setCaption(Name);
     dfp->show();
  }

  page->insert(Name, dfp);

  pageWidget->show();

  connect(dfp->getClient(), 
	  SIGNAL(signDelClient(const char*)),
	  this,
	  SLOT  (slotDelPage  (const char*)));
  connect(this,
	  SIGNAL(signCurrentPage(const char*)),
	  dfp,
	  SLOT  (slotCurrentPage(const char*)));
  connect(dfp,
	  SIGNAL(signDetach(bool, const char*)),
	  this,
	  SLOT  (slotDetach(bool, const char*)));

  QWidget* w=topLevelWidget();
  if (!w->isVisible())
     w->show();

  
  KTreeListItem* item;
  for (int i=0;i<treeList->count();i++){
     item = treeList->itemAt(i);
     if (!stricmp(Name, item->getText())){
        slotSetPage(i);
	return;
     }
  }
}

void DCCFileTab::slotDetach(bool detach, const char* name)
{
  ircapp->writeEntry( "DCCFileWindowDetach",   detach ? "Yes" : "No" );
  PageTab::slotDetach(detach, name);
}


