#include "StringToken.h"
#include "dccChatPage.h"
#include "dccChatTab.h"
#include "ircDefine.h"
#include <qregexp.h>

#include <iostream.h>
#include <qlayout.h>
#include "ircApp.h"

DCCChatPage::DCCChatPage(IrcClient* Client, QWidget* parent, const char* Name) :
             OutputPage(Client, parent, Name)
{
#ifdef EDEBUG
  cout << "DCCChatPage Konstruktor:"<<Name<<endl;
#endif
  dccClient  = client->dccChat->find(Name);
  if (!dccClient){
     cout << "DCC Object: " << Name <<" cannot be found" << endl;
     return;
  }

  connect(inpCmd, 
	  SIGNAL(signReturn(const char*)), 
	  dccClient, 
	  SLOT  (slotInputParse(const char*)));
  connect(dccClient, 
	  SIGNAL(signWriteMsg(int, const char*, bool)), 
	  SLOT  (slotWriteMsg(int, const char*, bool)));
  connect(dccClient, 
	  SIGNAL(signServe()), 
	  this, 
	  SLOT  (slotServe()));
  connect(dccClient, 
	  SIGNAL(signConnect()), 
	  this, 
	  SLOT  (slotConnect()));
  connect(dccClient, 
	  SIGNAL(signConnected()), 
	  this, 
	  SLOT  (slotConnected()));
  connect(dccClient, 
	  SIGNAL(signDisconnected()), 
	  this, 
	  SLOT  (slotDisconnected()));

  createMenu();
  createToolbar(); 
  createPopup();
}

DCCChatPage::~DCCChatPage()
{
#ifdef EDEBUG
  cout << "Destruktor DCCChatPage" << endl;
#endif;
}

void DCCChatPage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("DCCChat")))
     popup = client->popup.find("Default");

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotDCCPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotDCCPopupAction(const char*)));
  }
}

void DCCChatPage::slotDCCPopup(const char*, const QPoint& pos)
{
#ifdef EDEBUG
  cout <<"DCCChatPage::slotDCCPopup:"+QString(dccClient->name())<<endl;
#endif
  IrcPopup* popup = client->popup.find("DCCChat");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void DCCChatPage::slotDCCPopupAction(const char* Action)
{
  if ( IsSelected()==true && isActiveWindow()==true)
     dccClient->slotInputParse(Action);
}

void DCCChatPage::Init()
{
}

void DCCChatPage::createMenu()
{
}

void DCCChatPage::createToolbar()
{
}

void DCCChatPage::slotExit(MDIWindow*)
{
  client->delDCCChat(dccClient->name(), false);
}

void DCCChatPage::slotServe()
{
  InetAddress inAddr=dccClient->server.getLocalInetAddress();
  int port          =dccClient->server.getLocalPort();
  QString ps;
  ps.setNum(port);
  QString s="Wait connection on "+inAddr.getHostAddress()+":"+ps;
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(waitCursor);
}

void DCCChatPage::slotConnect()
{
  QString s="Try connect to host "+dccClient->host->Host()+" on port "+dccClient->host->Port();
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  s = "Please wait...";
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(waitCursor);
}

void DCCChatPage::slotConnected()
{
  QString s = "Connected to port "+dccClient->host->Port()+" of host "+dccClient->host->Host();
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(arrowCursor);
}

void DCCChatPage::slotDisconnected()
{
  QString s;
  if (dccClient->host)
    s = "Disconnected from host "+dccClient->host->Host()+" on port "+dccClient->host->Port();
  else
    s = "Disconnected...";
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(arrowCursor);
}

DCCChat* DCCChatPage::getClient()
{
  return dccClient;
}

void DCCChatPage::slotWriteMsg(int type, const char* txt, bool parse)
{
  htmlMsg->slotWrite(type, txt, parse);
  if (!IsSelected())
    emit signNewMsg();
}

#include "dccChatPage.moc"
