%{

#include "k2url.parse.h"

void yyerror(char *s);
int yylex();
void initFlex( const char *s );

%}

%union
{
     char *name;
}

%token <name> STRING
%token <name> REF
%token <name> PATH
%token DSLASH

/* Grammar follows */
     
%%

start: /* empty */
     | STRING DSLASH host { k2url_setProtocol( $<name>1 );  }
     | STRING DSLASH host path { k2url_setProtocol( $<name>1 ); }
     | STRING ':' path { k2url_setProtocol( $<name>1 ); }
     | path { }
;

host: STRING { k2url_setHost( $<name>1 ); }
    | STRING '@' STRING { k2url_setUser( $<name>1 ); k2url_setHost( $<name>3 ); }
    | STRING ':' STRING '@' STRING { k2url_setUser( $<name>1 ); k2url_setPass( $<name>3 ); k2url_setHost( $<name>5 ); }
    | STRING ':' STRING { k2url_setHost( $<name>1 ); k2url_setPort( $<name>3 ); }
    | STRING '@' STRING ':' STRING { k2url_setUser( $<name>1 ); k2url_setHost( $<name>3 ); k2url_setPort( $<name>5 ); }
    | STRING ':' STRING '@' STRING ':' STRING { k2url_setUser( $<name>1 ); k2url_setPass( $<name>3 ); k2url_setHost( $<name>5 ); k2url_setPort( $<name>7 ); }
;

path: PATH { k2url_setPath( $<name>1 ); }
    | PATH REF { k2url_setPath( $<name>1 ); k2url_setRef( $<name>2 ); }
    | REF { k2url_setRef( $<name>1 ); }
;

/* End of grammar */

%%

void k2urlerror ( char *s )  /* Called by yyparse on error */
{
  // printf ("ERROR: %s\n", s);
  k2url_setError();
}

void k2url_mainParse( char *_code )
{
  k2url_initFlex( _code );
  k2urlparse();
}
