/* $Id: kmytablistbox.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: kmytablistbox.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.5  1999/02/07 20:03:44  matt
   renamed timed to scheduled

   Revision 1.4  1999/02/07 17:14:12  matt
   added some new icons

   Revision 1.3  1998/12/19 19:39:19  matt
   Added new icons

   Revision 1.1.1.1  1998/05/06 19:13:31  matt
   Imported sources


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#ifndef KMyTabListBox_h
#define KMyTabListBox_h

#include <ktablistbox.h>

// Fileds constants
#define TB_PIXMAP          0
#define TB_LOCAL_FILENAME  1
#define TB_RESUME          2
#define TB_COUNT           3
#define TB_PROGRESS        4
#define TB_TOTAL           5
#define TB_SPEED           6
#define TB_REMAINING_TIME  7
#define TB_URL             8

class KMyTabListBox : public KTabListBox
{
  Q_OBJECT

public:
  KMyTabListBox (QWidget *parent=0, const char *name=0, 
	       int columns=1, WFlags f=0);
  virtual ~KMyTabListBox();

  uint getPhasesNum() { return phasesNum; }

  /*
     * hack to get static classes up and running even with C++-Compilers/
     * Systems where a constructor of a class element declared static
     * would never get called (Aix, Alpha,...). In the next versions these
     * elements should disappear.
     */
  static void initStatic() {
    animConn = new QList<QPixmap>;
    animTry = new QList<QPixmap>;
    pixQueued = new QPixmap;
    pixScheduled = new QPixmap;
    pixDelayed = new QPixmap;
    pixFinished = new QPixmap;
    pixRetrying = new QPixmap;
  }

protected:

  static QList<QPixmap> *animConn;
  static QList<QPixmap> *animTry;
  static QPixmap *pixQueued;
  static QPixmap *pixScheduled;
  static QPixmap *pixDelayed;
  static QPixmap *pixFinished;
  static QPixmap *pixRetrying;

  uint phasesNum;

};


#endif /*KMyTabListBox_h*/
