/* 
    kwintv using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "wintvscan.h"

#ifdef myDEBUG
#define scanDEBUG
#endif
#define scanDEBUG

#define Inherited winTVscanData

winTVscan::winTVscan(QWidget* parent, const char* name, rcfile * _rc, v4lxif * _v4lxifP)
  : Inherited( parent, name ),rc(_rc),v4lxifP(_v4lxifP)
{
  setCaption( "kwintv - Scan all Channels for Programs" );

  int i,aktive=0;
  for (i=0; i <= KNOWN_COUNTRIES; i++) {
    cntry->insertItem(chan_names[i].str,i);
  }
  cntry->setCurrentItem(rc->country_id);

  // fill in supported norms
  int tflags= v4lxifP->getTunerFlags();
  int tmode= v4lxifP->getChannelNorm();
  for (i = 0; norms[i].str != NULL; i++)  // XXXX
    if (tflags & (1<<i)) {
      snorm->insertItem(norms[i].str,i);
      if (tmode == i) aktive=i;
    }
  snorm->setCurrentItem(aktive);

  // fill in input sources
  for (i = 0; i < v4lxifP->capCapChannelC(); i++) {  // XXXX
    if (v4lxifP->capChannelTuner(i)) sinput->insertItem(v4lxifP->capChannelName(i),i);
  }
  sinput->setCurrentItem(0);

  clistview = new QListView(this,NULL);
  clistview->setGeometry( viewframe->geometry() );
  clistview->setFrameStyle( 51 );
  clistview->setLineWidth( 2 );
  clistview->setMultiSelection ( false );
  clistview->setAllColumnsShowFocus( true );
  clistview->setTreeStepSize( 0 ); 
  clistview->setRootIsDecorated( false );

  clistview->addColumn("Nr.");
  clistview->setColumnWidth(0,30);
  clistview->addColumn("Ch.");
  clistview->setColumnWidth(1,50);
  clistview->addColumn("Name");
  clistview->setColumnWidth(2, viewframe->width() - 50 - 30 - 15);
  
  cname=(char *)malloc(255);
}
winTVscan::~winTVscan()
{
  delete clistview;
  free(cname);
}
void winTVscan::setDataSLOT(QList<channel> *clist)
{
  index=0;
  cancelbutton->setEnabled(true);
  okbutton->setEnabled(true);
#if 0
  if (!clist->isEmpty()) {
    channel_list = *clist;

    channel *ch = channel_list.first();
    
    int nid= 1;
    
    while ( ch ) {
      QString id;
      id.sprintf("%2d",nid++);

      QListViewItem *lvi= new QListViewItem( clistview, 
					     (const char*)id, "", ch->name );
      clistview->ensureItemVisible(lvi);
      ch= channel_list.next();
    }
  }
#endif
  snorm->setCurrentItem(v4lxifP->getChannelNorm());
  norm= v4lxifP->getChannelNorm();
  sinput->setCurrentItem(0);
  input= 0;

  aktivecntry.change(rc->country_id);
  rc->country_name=QString(chan_names[rc->country_id].str);
}

void winTVscan::newInputSLOT(int id)
{
#ifdef scanDEBUG
  debug("scan: input %d",id);
#endif
  input=id;
  emit inputChangedSIGNAL(id);
}
void winTVscan::newNormSLOT(int id)
{
#ifdef scanDEBUG
  debug("scan: norm %d",id);
#endif
  norm=id;
  emit normChangedSIGNAL(id);
}
void winTVscan::newCountrySLOT(int id)
{
#ifdef scanDEBUG
  debug("scan: country %d",id);
#endif
  aktivecntry.change(id);
}
void winTVscan::scanbuttonSLOT()
{
  frequency=aktivecntry.firstchan(cname);
  emit frequencyChangedSIGNAL(frequency);

  channel_list.clear();
  clistview->clear();
  
  fchan= aktivecntry.activeindex();
#if 0
  cancelbutton->setEnabled(false);
  okbutton->setEnabled(false);
  scanbutton->setEnabled(false);
  cntry->setEnabled(false);
  snorm->setEnabled(false);
  sinput->setEnabled(false);
#endif
  progressview= new QProgressDialog( "Scaning...", "Stop Scan", aktivecntry.nftab(), this, "progress", true );
  progressview-> setMinimumDuration(TIMEWAIT/2);
  progressview->setProgress(0);
  index=channel_list.count();
#ifdef scanDEBUG
  debug("scan: start scan");
#endif
  finished=false;
  runScanSLOT();
}
void winTVscan::runScanSLOT()
{
  progressview->setProgress( aktivecntry.activeindex()+1 );
  if ( !finished && !progressview->wasCancelled() ) {
    QTimer::singleShot( TIMEWAIT, this, SLOT(checkScanSLOT()) );
    return;
  }
  progressview->setProgress( aktivecntry.nftab() );
#if 0
  cancelbutton->setEnabled(true);
  okbutton->setEnabled(true);
  scanbutton->setEnabled(true);
  cntry->setEnabled(true);
  snorm->setEnabled(true);
  sinput->setEnabled(true);
#endif
}
void winTVscan::checkScanSLOT()
{
  long quality= v4lxifP->getTunerSignal();
#ifdef scanDEBUG
  debug("scan: checking channel %s",cname);
#endif
  if ( (quality > SIGQUALITY) ) {
    
    // add channel to list
    QString id;
    id.sprintf("%2d",++index);

    QString ch;
    ch.sprintf("%s",cname);

    QString name;
    name.sprintf("prog_%d",aktivecntry.activeindex());

#ifdef scanDEBUG
  debug("scan: adding %d, %s, %s, n %d, i %d, cntry %d",
	index, (const char*)ch, (const char*)name,norm,input,aktivecntry.cid());
#endif
    QListViewItem *lvi= new QListViewItem( clistview, 
					   (const char*)id, (const char*)ch, (const char*)name );
    
    channel *s=new channel(frequency,(const char*)name,
			   rc->col,rc->bri,rc->hue,rc->contr,norm,input,aktivecntry.cid(),
			   (const char*)ch);
    channel_list.append(s);

    clistview->setCurrentItem(lvi);
    clistview->ensureItemVisible(lvi);
    frequency=aktivecntry.nextchan(cname);
    if (fchan == aktivecntry.activeindex()) {
      finished=true;
    }
    emit frequencyChangedSIGNAL(frequency);
    runScanSLOT();

  } else {

    frequency=aktivecntry.nextchan(cname);
    if (fchan == aktivecntry.activeindex()) {
      finished=true;
    }
    emit frequencyChangedSIGNAL(frequency);
    runScanSLOT();
  }
}

void winTVscan::cancelbuttonSLOT()
{
  emit readyScanChannelsSIGNAL(0);
}
void winTVscan::okbuttonSLOT()
{
  emit readyScanChannelsSIGNAL(index);
}
#include "wintvscan.moc"










