#ifndef TOGGLECOLOR_H
#define TOGGLECOLOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qcheckbox.h>
#include <qcolor.h>

class ToggleColor : public QFrame
{
	Q_OBJECT
public:
	ToggleColor( QWidget *parent, QColor *on_color );

	void setState( bool newstate );
	void setText( QString newtext );
	void mousePressEvent( QMouseEvent * );
	void paintEvent( QPaintEvent *pev );

signals:
	void valueChanged( bool );

private:
	QColor *onColor;
	QString *title;
	bool state;
};

#endif // TOGGLECOLOR_H
