#include <kfiledialog.h>
#include <qpainter.h>

#include <thudgrid.h>
#include <thudline.h>
#include <thudline.moc>
#include <globals.h>

SampleName::SampleName( QWidget *parent )
	: QFrame( parent, 0, 0, TRUE )
{
//	setFrameStyle( QFrame::Panel | QFrame::Raised );

	setName( QString( "No Sample Loaded" ) );
	resize( 140, 50 ); // only width matters now
}

void SampleName::setName( QString newname )
{
	namestring = new QString( newname.copy().right( 20 ) );
	repaint();
}

void SampleName::paintEvent( QPaintEvent *pev )
{
	QFrame::paintEvent( pev );
	QPainter paint( this );

	paint.drawText( 5, 15, *namestring );	
	paint.end();
}

ThudLine::ThudLine( int songchannel, QWidget *parent = 0 )
	: QWidget( parent, 0 )
{
	int i, curwidth;

	channel = songchannel;
	curwidth = 0;

	namebox = new SampleName( this );

	load = new BToolButton( false, this );
	load->setText( "Load" );
	QObject::connect( load, SIGNAL( pressed() ), this, SLOT( loadSamplePressed() ) );

	mute = new ToggleColor( this, new QColor( yellow ) );
  	mute->setText( "M" );
	QObject::connect( mute, SIGNAL( valueChanged( bool ) ), this, SLOT( mutePressed( bool ) ) );
	mute->resize( 18, namebox->height() );

	solo = new ToggleColor( this, new QColor( green ) );
	solo->setText( "S" );
	QObject::connect( solo, SIGNAL( valueChanged( bool ) ), this, SLOT( soloPressed( bool ) ) );
	solo->resize( 18, namebox->height() );

	curwidth += namebox->width() + mute->width();

	for ( i = 0; i < THUD_NUM_BEATS; i++ ) {
		button[ i ] = new WatcherTogglePixmap( this, 0,
				( (ThudGrid *) parent )->onPixmap[ i ],
				( (ThudGrid *) parent )->offPixmap[ i ] );
		button[ i ]->setUpdatePointer( (gsong->getNoteDataPtr( channel, gsong->getCurPat(), i )) );
		button[ i ]->move( curwidth, 0 );
		curwidth += button[ i ]->width();
	}

	namebox->resize( namebox->width(), button[ 0 ]->height() / 2 );

	load->resize( namebox->width() / 2, button[ 0 ]->height() / 2 );
	load->move( 0, namebox->height() );

//	mute->resize( namebox->width() / 4, button[ 0 ]->height() / 2 );
//	mute->move( load->width(), namebox->height() );
	mute->resize( mute->width(), namebox->height() );
	mute->move( namebox->width(), 0 );

//	solo->resize( namebox->width() / 4, button[ 0 ]->height() / 2 );
//	solo->move( load->width() + mute->width(), namebox->height() );
	solo->resize( solo->width(), load->height() );
	solo->move( namebox->width(), namebox->height() );

	volumeSelect = new QSlider( 0, 150, 5, 100, QSlider::Horizontal, this );
	volumeSelect->setTickmarks( QSlider::Below );
	volumeSelect->setTickInterval( 30 );
	volumeSelect->setValue( 80 );
	volumeSelect->resize( 100, button[ 0 ]->height() / 2 );
	volumeSelect->move( curwidth, 0 );
	QObject::connect( volumeSelect, SIGNAL( valueChanged( int ) ), this, SLOT( setVolume( int ) ) );

	panSelect = new QSlider( -100, 100, 5, 0, QSlider::Horizontal, this );
	panSelect->setTickmarks( QSlider::Above );
	panSelect->setTickInterval( 100 );
	panSelect->resize( 100, button[ 0 ]->height() / 2 );
	panSelect->move( curwidth, button[ 0 ]->height() / 2 );
	QObject::connect( panSelect, SIGNAL( valueChanged( int ) ), this, SLOT( setPan( int ) ) );

	curwidth += volumeSelect->width();

	resize( curwidth, button[ 0 ]->height() );
}

void ThudLine::updateNotePointers()
{
	int i;

	for ( i = 0; i < THUD_NUM_BEATS; i++ ) {
		button[ i ]->setUpdatePointer( gsong->getNoteDataPtr( channel, gsong->getCurPat(), i ) );
		button[ i ]->setState( (bool) gsong->getSongNote( channel, gsong->getCurPat(), i ) );
	}
}

void ThudLine::loadSamplePressed()
{
	QString s( KFileDialog::getOpenFileName( 0, "*.wav" ) );

	if ( s.isNull() ) return;

	gsong->getChannelSample( channel )->loadSample( s );
	namebox->setName( s );
}

void ThudLine::mutePressed( bool newmute )
{
	gsong->setChannelMute( channel, newmute );

	// We also want to stop the channel from making noise
	if ( newmute == true ) {
		gsong->getChannelSample( channel )->off();
	}
}

void ThudLine::soloPressed( bool newsolo )
{
	gsong->setChannelSolo( channel, newsolo );
}

void ThudLine::setVolume( int newvolume )
{
	gsong->getChannelSample( channel )->setVolume( newvolume );
}

void ThudLine::setPan( int newpan )
{
	gsong->getChannelSample( channel )->setPan( newpan );
}

