#include "samplechannel.h"
#include "constants.h"
#include "wave.h"

sampleChannel::sampleChannel() {
	data = NULL;
	size = 0;
	pos = 0;
	pan = 0.0;
	volume = DEFAULT_CHANNEL_VOLUME;
	master_volume = 0.8;
	calculateAmplification();
	original_filename = "";
}

void sampleChannel::loadSample( const char *filename ) {
	wave_t wavefile;

	if ( !wavefile.load_sample( filename ) ) return;

	if ( data != NULL ) delete[] data;

	data = new sample_t[ wavefile.get_size() ];
	memcpy( data, wavefile.get_buffer(), wavefile.get_size() * sizeof( sample_t ) );
	size = wavefile.get_size();
	original_filename = filename;
	off();
}

void sampleChannel::calculateAmplification() {
	if ( pan >= 0 ) {
		left_amp = 1 - pan;
		right_amp = 1;
	} else {
		right_amp = 1 + pan;
		left_amp = 1;
	}
	right_amp *= volume * getMasterVolume();
	left_amp *= volume * getMasterVolume();
}

void sampleChannel::setPan( int newpan ) {
	pan = 0.01 * (float) newpan;
	calculateAmplification();
}

void sampleChannel::setVolume( int newvol ) {
	volume = 0.01 * (float) newvol;
	calculateAmplification();
}

