#include <globals.h>
#include <bsongposition.h>
#include <bsongposition.moc>

BSongPosition::BSongPosition( QWidget *parent )
	: QWidget( parent )
{
	int curwidth, height;
	QString text;

	curwidth = 5; // Give a little room at the front
	height = parent->height() - 2; // Height of the toolbar?
	cpat = gsong->getCurPat();
	cbeat = gsong->getCurBeat();

	pattern = new QLabel( this );
	pattern->setText( "Pattern:" );
	pattern->resize( 50, height );
	pattern->move( curwidth, 0 );

	curwidth += pattern->width();

	curpattern = new BToolButton( false, this );
	text.sprintf( "%d", cpat );
	curpattern->setText( text );
	curpattern->resize( 20, height );
	curpattern->move( curwidth, 0 );

	curwidth += curpattern->width();

	beat = new QLabel( this );
	beat->setText( "Beat:" );
	beat->resize( 50, height );
	beat->move( curwidth, 0 );

	curwidth += beat->width();

	curbeat = new BToolButton( false, this );
	text.sprintf( "%d", cbeat );
	curbeat->setText( text );
	curbeat->resize( 20, height );
	curbeat->move( curwidth, 0 );

	curwidth += curbeat->width();

	resize( curwidth, height );

	updatetimer = new QTimer( this );
	QObject::connect( updatetimer, SIGNAL( timeout() ), this, SLOT( updateTimerTick() ) );
	updatetimer->start( 100 );
}

void BSongPosition::updateTimerTick()
{
	QString newtext;

	if ( gsong->getCurPat() != cpat ) {
		newtext.sprintf( "%d", gsong->getCurPat() );
		curpattern->setText( newtext );
		cpat = gsong->getCurPat();
	}
	if ( gsong->getCurBeat() != cbeat ) {
		newtext.sprintf( "%d", gsong->getCurBeat() );
		curbeat->setText( newtext );
		cbeat = gsong->getCurBeat();
	}
}

