#include <stdio.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <globals.h>

#include <bbpmselect.h>
#include <bbpmselect.moc>

#include "pics/note.xpm"

setBPMWidget::setBPMWidget( QWidget *parent )
	: QWidget( parent )
{
	setCaption( "BPM Select" );

	label = new QLabel( this );
	label->setText( " New BPM: " );
	label->move( 0, 0 );
	label->resize( 75, label->height() );

	setbpm = new QLineEdit( this );
	setbpm->move( label->width() + 1, 0 );
	setbpm->resize( 100, label->height() );
	QObject::connect( setbpm, SIGNAL( returnPressed() ), this, SLOT( _pushedOkay() ) );

	okay = new QPushButton( this );
	okay->setText( "Okay" );
	okay->move( 0, label->height() );
	okay->resize( ( label->width() + setbpm->width() ) / 2, 25 );
	QObject::connect( okay, SIGNAL( clicked() ), this, SLOT( _pushedOkay() ) );

	cancel = new QPushButton( this );
	cancel->setText( "Cancel" );
	cancel->move( okay->width(), label->height() );
	cancel->resize( okay->width(), okay->height() );
	QObject::connect( cancel, SIGNAL( clicked() ), this, SLOT( _pushedCancel() ) );

	resize( okay->width() + cancel->width(), label->height() + okay->height() );
}

void setBPMWidget::_pushedOkay()
{
	QString s;

	s = setbpm->text();

	newValue( s.toInt() );

	this->hide();
}

void setBPMWidget::_pushedCancel()
{
	this->hide();
}

void setBPMWidget::setText( const char *newtext )
{
	setbpm->setText( newtext );
}

BBPMSelect::BBPMSelect( QWidget *parent )
	: QWidget( parent )
{
	note = new QLabel( this );
	note->setPixmap( QPixmap( ( const char **) note_xpm ) );
	note->move( 10, 0 );
	note->resize( 22, 22 );

	equals = new QLabel( this );
	equals->setText( "=" );
	equals->move( 32, 0 );
	equals->resize( 8, 22 );

	changebpm = new BToolButton( false, this );
	changebpm->resize( 60, parent->height() - 2 );
	changebpm->move( 42, 0 );
	QObject::connect( changebpm, SIGNAL( pressed() ), this, SLOT( changingBPM() ) );
	QToolTip::add( changebpm, "Change Song BPM" );

	setbpm = new setBPMWidget( 0 );
	QObject::connect( setbpm, SIGNAL( newValue( int ) ), this, SLOT( setBPM( int ) ) );

	resetBPM();
	resize( 102, parent->height() );
}

void BBPMSelect::changingBPM()
{
	char newtext[ 10 ];

	sprintf( newtext, "%d", gsong->getTempo() );
	setbpm->setText( newtext );
	setbpm->show();
}

void BBPMSelect::setBPM( int newbpm )
{
	char newtext[ 10 ];

	if ( ( newbpm < 20 ) || ( newbpm > 500 ) ) {
		return;
	}

	sprintf( newtext, "%d bpm", newbpm );
	changebpm->setText( newtext );
	gsong->setTempo( newbpm );
}

void BBPMSelect::resetBPM()
{
	setBPM( gsong->getTempo() );
}

